/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "vpf_coverage_attribute_table.h"

void coverage_attribute_delete(COVERAGE_ATTRIBUTE_RECORD *tbl){
	if(tbl->description){
		free(tbl->description);
	}
	free(tbl);
}

VPF_RECORD_READER_BEGIN(
	coverage_attribute_read, 
	COVERAGE_ATTRIBUTE_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD(coverage_name)
	VPF_READ_VARIABLE_TEXT_FIELD(description)
	VPF_READ_FIELD(level)
VPF_RECORD_READER_END()
