/**********************************************************************
 
	Copyright (C) 2008- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"spidering.h"

XL_SEXP * gb_SPdeletePath();

void
init_gb_SPdeletePath(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SPdeletePath"),
		get_func_prim(gb_SPdeletePath,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
gb_SPdeletePath(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
XL_SEXP * path;
char * err;
	path = get_el(s,1);
	err = "path";
	if ( get_type(path) != XLT_STRING )
		goto type_missmatch;
	if ( delete_sp_path_auth(wa_list,path->string.data) < 0 )
		goto already_exist;
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SPdeletePath"),
		List(n_get_string("type missmatch"),n_get_string(err),-1));
already_exist:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_UNDEF_RESOURCE,
		l_string(std_cm,"SPdeletePath"),
		List(n_get_string("already exist agent"),
			-1));
}

