/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"xlerror.h"
#include	"authentification.h"
#include	"lock_level.h"

XL_SEXP *
xl_auth_service(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_auth_target(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
XL_SEXP *
xl_auth_transaction(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
AUTH_SERVICE_LIST *
new_auth_service_list(AUTH_SERVICE * s,AUTH_SERVICE_LIST * lst,int type);


SEM auth_lock;
XLISP_ENV * auth_env;
int auth_gc_no;

AUTH_TABLE att[] = {
	{AT_FIX_USER_PASSWD,"fix-user-passwd",1,1,
		new_auth_service_fix_user_passwd,
		parse_info_fix_user_passwd,
			free_auth_service_fix_user_passwd,
			server_send_sexp_fix_user_passwd,
			client_recv_sexp_fix_user_passwd,
			authentification_fix_user_passwd,
			0,
		new_auth_result_fix_user_passwd,
			free_auth_result_fix_user_passwd,
			send_result_info_fix_user_passwd,
			recv_result_info_fix_user_passwd,
			set_authentification_result_fix_user_passwd,
			0,
			get_result_members_fix_user_passwd},
	{AT_LOCALHOST_ROOT,"localhost-root",1,1,
		new_auth_service_localhost_root,
		parse_info_localhost_root,
			free_auth_service_localhost_root,
			server_send_sexp_localhost_root,
			client_recv_sexp_localhost_root,
			authentification_localhost_root,
			gc_service_localhost_root,
		new_auth_result_localhost_root,
			free_auth_result_localhost_root,
			send_result_info_localhost_root,
			recv_result_info_localhost_root,
			set_authentification_result_localhost_root,
			client_transaction_localhost_root,
			get_result_members_localhost_root},
	{AT_TMP,0,0,0,
		0,0,0,
		0,0,0,0,0}
};

AUTH_SET_CLIENT auth_set_client;
AUTH_SET_SERVER auth_set_server;


void
init_authentificaition(XLISP_ENV * env)
{

#define DEF_ARS(ars)	set_env(env,l_string(std_cm,#ars),get_integer(ars,0));

	auth_lock = new_lock(LL_AUTH);
	auth_env = new_env(env);
	set_env(env,l_string(std_cm,"authentification"),get_env(auth_env));
	set_env(auth_env,l_string(std_cm,"service"),
		get_func_prim(xl_auth_service,FO_APPLICATIVE,0,1,1));
	set_env(auth_env,l_string(std_cm,"target"),
		get_func_prim(xl_auth_target,FO_APPLICATIVE,0,1,-1));
	set_env(env,l_string(std_cm,"auth-transaction"),
		get_func_prim(xl_auth_transaction,FO_APPLICATIVE,0,4,4));

	DEF_ARS(ARS_NONE)
	DEF_ARS(ARS_DENY)
	DEF_ARS(ARS_ACCEPT)

	DEF_ARS(ARS_NOT_USE)
	DEF_ARS(ARS_REQUIRED)
	DEF_ARS(ARS_SEND_PERMIT)
}

AUTH_TABLE *
at_tbl(int type)
{
AUTH_TABLE * tbl;
	for ( tbl = &att[0] ; tbl->type != AT_TMP ; tbl ++ ) {
		if ( tbl->type == type )
			return tbl;
	}
	return 0;
}

AUTH_TABLE * 
at_tbl_type_name(char * name)
{
AUTH_TABLE * tbl;
	for ( tbl = &att[0] ; tbl->type != AT_TMP ; tbl ++ ) {
		if ( strcmp(tbl->name,name) == 0 )
			return tbl;
	}
	return 0;
}

AUTH_SERVICE * 
new_auth_service_header(AUTH_SERVICE * s,AUTH_TABLE * tbl)
{
AUTH_SERVICE * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->h = s->h;
	if ( ret->h.tbl == 0 )
		ret->h.tbl = tbl;
	ret->h.service_name = ll_copy_str(s->h.service_name);
	ret->h.description = ll_copy_str(s->h.description);
	ret->h.description_url = ll_copy_str(s->h.description_url);
	tbl = ret->h.tbl;
	if ( tbl->default_open_service_name == 0 )
		ret->h.open_service_name = 0;
	if ( tbl->default_open_service_type == 0 )
		ret->h.open_service_type = 0;
	return ret;
}


void
free_auth_service_header(AUTH_SERVICE * s)
{
	if ( s->h.service_name )
		d_f_ree(s->h.service_name);
	if ( s->h.description )
		d_f_ree(s->h.description);
	if ( s->h.description_url )
		d_f_ree(s->h.description_url);
}

AUTH_SERVICE * 
get_service_header(AUTH_SET_SERVER * set,XL_SEXP * s)
{
XL_SEXP * sym;
AUTH_SERVICE param,* ret;
AUTH_SERVICE_LIST * lst;
L_CHAR * service_type;

	sym = car(s);
	if ( get_type(sym) != XLT_SYMBOL )
		return 0;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"service")) )
		return 0;
	memset(&param,0,sizeof(param));
	param.h.service_name = get_sf_attribute(sym->symbol.field,l_string(std_cm,"name"));
	param.h.description = get_sf_attribute(sym->symbol.field,l_string(std_cm,"description"));
	param.h.description_url = get_sf_attribute(sym->symbol.field,l_string(std_cm,"description-url"));
	service_type = get_sf_attribute(sym->symbol.field,l_string(std_cm,"type"));
	if ( service_type )
		param.h.tbl = at_tbl_type_name(n_string(std_cm,service_type));
	if ( param.h.service_name )
		param.h.open_service_name = 1;
	if ( param.h.tbl )
		param.h.open_service_type = 1;
	if ( set == 0 ) {
		for ( lst = auth_set_client.auth_service_list ; lst ; lst = lst->next ) {
			if ( param.h.service_name == 0 )
				goto next1;
			if ( l_strcmp(param.h.service_name,lst->service->h.service_name) )
				continue;
		next1:
			if ( param.h.tbl == 0 )
				break;
			if ( lst->service->h.tbl == param.h.tbl )
				break;
		}
	}
	else {
		for ( lst = set->auth_service_list ; lst ; lst = lst->next ) {
			if ( param.h.service_name == 0 )
				goto next2;
			if ( l_strcmp(param.h.service_name,lst->service->h.service_name) )
				continue;
		next2:
			if ( param.h.tbl == 0 )
				break;
			if ( lst->service->h.tbl == param.h.tbl )
				break;
		}
	}
	if ( lst )
		return lst->service;
	if ( param.h.tbl == 0 )
		param.h.tbl = at_tbl(AT_UNDEF);
	ret = (*param.h.tbl->new_auth_service)(&param);
	if ( set == 0 ) {
		lst = new_auth_service_list(ret,0,ASL_NONE);
		lst->next = auth_set_client.auth_service_list;
		auth_set_client.auth_service_list = lst;
	}
	return ret;
}

XL_SEXP *
get_service_header_sexp(AUTH_SERVICE * s)
{
XL_SEXP *sym;
	sym = n_get_symbol("service");
	if ( s->h.service_name )
		set_attribute(sym,l_string(std_cm,"name"),s->h.service_name);
	if ( s->h.description )
		set_attribute(sym,l_string(std_cm,"description"),s->h.description);
	if ( s->h.description_url )
		set_attribute(sym,l_string(std_cm,"description-url"),s->h.description_url);
	if ( s->h.tbl )
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,s->h.tbl->name));
	return List(sym,-1);
}

XL_SEXP * 
get_result_header_sexp(AUTH_RESULT * r)
{
XL_SEXP * ret,* sym;
char buf[10];
	ret = get_service_header_sexp(r->h.service);
	sym = car(ret);
	sprintf(buf,"%i",r->h.status);
	set_attribute(sym,l_string(std_cm,"status"),l_string(std_cm,buf));
	return ret;
}



AUTH_DIR *
_parse_xlaccess(AUTH_SET_SERVER * set,AUTH_DIR * a,L_CHAR * path)
{
L_CHAR * _path;
L_CHAR * _p;
int len1,len2;
STREAM * st;
AUTH_DIR * ret;
L_CHAR * tp;
XL_SEXP *xla;
XL_SEXP * _ret;
XLISP_ENV * env;
	tp = 0;
	_path = 0;
	_p = 0;
	if ( path == 0 || a == 0 ) {
		_path = nl_copy_str(std_cm,"/.xlaccess");
		tp = nl_copy_str(std_cm,"/");
	}
	else {
		_path = ll_copy_str(a->total_path);
		len1 = l_strlen(_path);
		len2 = l_strlen(path);
		_path = d_re_alloc(_path,sizeof(L_CHAR)*(len1+len2+50));
		l_strcpy(&_path[len1],path);
		_path[len1+len2] = '/';
		_path[len1+len2+1] = 0;
		tp = ll_copy_str(_path);
		
		l_strcpy(&_path[len1+len2+1],l_string(std_cm,".xlaccess"));
	}
	_p = get_xldocs(_path);
	st = s_open_file(n_string(std_cm,_p),O_RDONLY,0);
	if ( st == 0 ) {
		d_f_ree(_p);
		_p = get_xlsys(_path);
		st = s_open_file(n_string(std_cm,_p),O_RDONLY,0);
		if ( st == 0 ) {
			d_f_ree(_path);
			_path = 0;
			goto nothing;
		}
	}
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	if ( path )
		ret->dir_name = ll_copy_str(path);
	else	ret->dir_name = 0;
	ret->total_path = tp;
	tp = 0;

	xla = init_parse(st,l_string(std_cm,".xlaccess"),l_string(std_cm,".xlaccess"));
	set_encoding(xla);
	xla = cdr(get_el(xla,1));
	env = new_env(auth_env);
	set_env_work(env,ret);
	for ( ; get_type(xla) == XLT_PAIR ; xla = cdr(xla) ) {
		_ret = eval(env,car(xla));
		if ( get_type(_ret) == XLT_ERROR ) {
			print_sexp(s_stdout,_ret,0);
			ss_printf("\n");
			break;
		}
	}
	goto end;
nothing:
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	if ( path )
		ret->dir_name = ll_copy_str(path);
	else	ret->dir_name = 0;
	ret->total_path = tp;
	tp = 0;
end:
	if ( tp )
		d_f_ree(tp);
	if ( _path )
		d_f_ree(_path);
	if ( _p )
		d_f_ree(_p);
	return ret;
}


AUTH_SERVICE_LIST *
copy_auth_service_list(AUTH_SERVICE_LIST * lst)
{
AUTH_SERVICE_LIST * ret,** rp,*r;
	ret = 0;
	rp = &ret;
	for ( ; lst ; lst = lst->next ) {
		r = d_alloc(sizeof(*r));
		*r = *lst;
		if ( lst->list )
			r->list = copy_auth_service_list(lst->list);
		r->next = 0;
		*rp = r;
		rp = &r->next;
	}
	return ret;
}

AUTH_SERVICE_LIST *
append_auth_service_list(AUTH_SERVICE_LIST * a,AUTH_SERVICE_LIST * b,int type)
{
AUTH_SERVICE_LIST * tmp;
	if ( a == 0 )
		return b;
	if ( b == 0 )
		return a;
	if ( a->type != type ) {
		tmp = d_alloc(sizeof(*tmp));
		tmp->type = type;
		tmp->service = 0;
		tmp->list = a;
		tmp->next = 0;
		a = tmp;
	}
	if ( b->type != type ) {
		tmp = d_alloc(sizeof(*tmp));
		tmp->type = type;
		tmp->service = 0;
		tmp->list = b;
		tmp->next = 0;
		b = tmp;
	}
	for ( tmp = a ; tmp->next ; tmp = tmp->next );
	tmp->next = b;
	return a;
}

AUTH_SERVICE_LIST *
new_auth_service_list(AUTH_SERVICE * s,AUTH_SERVICE_LIST * lst,int type)
{
AUTH_SERVICE_LIST * ret;
	ret = d_alloc(sizeof(*ret));
	ret->service = s;
	ret->list = lst;
	ret->type = type;
	ret->next = 0;
	return ret;
}

void
free_auth_service_list(AUTH_SERVICE_LIST * lst,int service_header_flag)
{
AUTH_SERVICE_LIST * lst2;
	for ( ; lst ; ) {
		lst2 = lst->next;
		if ( lst->service && service_header_flag )
			(*lst->service->h.tbl->free_auth_service)(lst->service);
		if ( lst->list )
			free_auth_service_list(lst->list,service_header_flag);
		d_f_ree(lst);
		lst = lst2;
	}
}

AUTH_RESULT_LIST *
new_auth_result_list(AUTH_RESULT * r,AUTH_RESULT_LIST * lst,int type)
{
AUTH_RESULT_LIST * ret;
	ret = d_alloc(sizeof(*ret));
	ret->result = r;
	ret->list = lst;
	ret->type = type;
	ret->next = 0;
	return ret;
}

void
free_auth_result_list(AUTH_RESULT_LIST * lst)
{
AUTH_RESULT_LIST * lst2;
	for ( ; lst ; ) {
		lst2 = lst->next;
		if ( lst->list )
			free_auth_result_list(lst->list);
		d_f_ree(lst);
		lst = lst2;
	} 
}

XL_SEXP * 
_ap_server_send_sexp(AUTH_SERVICE_LIST * lst)
{
XL_SEXP * ret,*sym;
AUTH_SERVICE * s;
	if ( lst == 0 )
		return 0;
	sym = n_get_symbol("service-list");
	switch ( lst->type ) {
	case ASL_NONE:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"none"));
		break;
	case ASL_AND:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"and"));
		break;
	case ASL_OR:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"or"));
		break;
	default:
		er_panic("_ap");
	}
	ret = cons(sym,0);
	for ( ; lst ; lst = lst->next ) {
		if ( lst->service ) {
			s = lst->service;
			if ( s->h.open_service_name == 0 && s->h.open_service_type == 0 )
				continue;
			sym = n_get_symbol("service");
			if ( s->h.open_service_name )
				set_attribute(sym,l_string(std_cm,"name"),s->h.service_name);
			if ( s->h.open_service_type )
				set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,s->h.tbl->name));
			if ( s->h.description )
				set_attribute(sym,l_string(std_cm,"description"),s->h.description);
			if ( s->h.description_url )
				set_attribute(sym,l_string(std_cm,"description-url"),s->h.description_url);
			(*s->h.tbl->server_send_sexp)(s,sym);
			ret = cons(List(sym,-1),ret);
		}
		else {
			sym = _ap_server_send_sexp(lst->list);
			if ( sym == 0 )
				continue;
			ret = cons(sym,ret);
		}
	}
	return reverse(ret);
}

AUTH_SERVICE_LIST *
_ap_client_recv_sexp(XL_SEXP * s)
{
XL_SEXP * sym,*t;
int _type;
AUTH_SERVICE_LIST * ret,** rp,*r,*sv_l;
AUTH_SERVICE * sv;
L_CHAR * name,* type;
AUTH_TABLE * tbl;

	if ( get_type(s) == XLT_NULL )
		return 0;
	if ( get_type(s) != XLT_PAIR )
		return 0;
	sym = car(s);
	if ( get_type(sym) != XLT_SYMBOL )
		return 0;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"service-list")) )
		return 0;
	type = get_sf_attribute(sym->symbol.field,l_string(std_cm,"type"));
	if ( type == 0 )
		return 0;
	if ( l_strcmp(type,l_string(std_cm,"and")) == 0 )
		_type = ASL_AND;
	else if ( l_strcmp(type,l_string(std_cm,"or")) == 0 )
		_type = ASL_OR;
	else	_type = ASL_NONE;
	ret = 0;
	rp = &ret;
	s = cdr(s);
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		t = car(s);
		if ( get_type(t) != XLT_PAIR )
			continue;
		sym = car(t);
		if ( get_type(sym) != XLT_SYMBOL )
			continue;
		if ( l_strcmp(sym->symbol.data,l_string(std_cm,"service-list")) == 0 ) {
			r = _ap_client_recv_sexp(t);
			if ( r == 0 )
				continue;
			*rp = new_auth_service_list(0,r,_type);
			rp = &(*rp)->next;
		}
		else if ( l_strcmp(sym->symbol.data,l_string(std_cm,"service")) == 0 ) {
			type = get_sf_attribute(sym->symbol.field,l_string(std_cm,"type"));
			if ( type )
				tbl = at_tbl_type_name(n_string(std_cm,type));
			else	tbl = 0;
			name = get_sf_attribute(sym->symbol.field,l_string(std_cm,"name"));
			for ( sv_l = auth_set_client.auth_service_list ; sv_l ; sv_l = sv_l->next ) {
				if ( sv_l->service->h.tbl != tbl )
					continue;
				if ( name == 0 && sv_l->service->h.service_name )
					continue;
				if ( name && l_strcmp(name,sv_l->service->h.service_name) )
					continue;
				sv = sv_l->service;
				goto next;
			}
			sv = d_alloc(sizeof(*sv));
			memset(sv,0,sizeof(*sv));
			sv->h.tbl = tbl;
			sv->h.service_name = ll_copy_str(name);
			sv->h.description = ll_copy_str(get_sf_attribute(sym->symbol.field,l_string(std_cm,"description")));
			sv->h.description_url = ll_copy_str(get_sf_attribute(sym->symbol.field,l_string(std_cm,"description-url")));
			sv->h.service_name = ll_copy_str(name);
			if ( tbl )
				(*tbl->client_recv_sexp)(sv,sym);
			
			sv_l = new_auth_service_list(sv,0,ASL_NONE);
			sv_l->next = auth_set_client.auth_service_list;
			auth_set_client.auth_service_list = sv_l;
		next:
			*rp = new_auth_service_list(sv,0,_type);
			rp = &(*rp)->next;
		}
	}
	return ret;
}


AUTH_SERVICE_LIST *
_exec_authentification_2(AUTH_DIR * ad,L_CHAR * prefix,char * operation)
{
AUTH_PREFIX * pf;

	for ( pf = ad->prefix ; pf ; pf = pf->next ) {
		if ( pf->prefix == 0 && pf->operation == 0 )
			return copy_auth_service_list(pf->at_list);
		if ( prefix && pf->prefix && l_strcmp(pf->prefix,prefix) )
			continue;
		if ( operation && pf->operation && strcmp(pf->operation,operation) )
			continue;
		return copy_auth_service_list(pf->at_list);
	}
	return 0;
}

AUTH_SERVICE_LIST *
_exec_authentification(AUTH_SET_SERVER * set_server,L_CHAR * path,char * operation)
{
L_CHAR * _path;
L_CHAR ** _path_list;
int p_len;
int i,j,last_p;
AUTH_DIR * ad,*ad2;
L_CHAR * prefix;
AUTH_SERVICE_LIST * rr;
AUTH_SERVICE_LIST * ret;
	_path = ll_copy_str(path);
	for ( i = l_strlen(_path)-1 ; i >= 0 ; i -- )
		if ( _path[i] == '.' || _path[i] == '/' )
			break;
	if ( i < 0 ) {
		prefix = 0;
		last_p = 0;
	}
	else if ( _path[i] == '.' ) {
		prefix = &_path[i];
		for ( last_p = i-1 ; last_p >= 0 ; last_p -- )
			if ( _path[last_p] == '/' )
				break;
		if ( last_p < 0 )
			last_p = 0;
	}
	else if ( _path[i] == '/' ) {
		prefix = 0;
		last_p = i;
	}
	p_len = 0;
	for ( i = 0 ; _path[i] ; i++ ) {
		if ( _path[i] == '/' )
			p_len ++;
	}
	p_len += 5;
	_path_list = d_alloc(sizeof(L_CHAR*)*p_len);
	j= 0;
	_path_list[j++] = _path;
	for ( i = 0 ; i <= last_p ; i ++ ) {
		if ( _path[i] == '/' ) {
			_path_list[j++] = &_path[i+1];
			_path[i] = 0;
		}
	}
	_path_list[j-1] = 0;
	i = 0;
	ret = 0;
	if ( set_server->auth_dir_tree == 0 )
		set_server->auth_dir_tree = _parse_xlaccess(set_server,0,0);
	for ( ad = set_server->auth_dir_tree ; ad ; i ++ ) {
		rr = _exec_authentification_2(ad,prefix,operation);
		if ( rr )
			ret = append_auth_service_list(rr,ret,ASL_AND);

		for ( ; _path_list[i] && _path_list[i][0] == 0 ; i ++ );
		if ( _path_list[i] == 0 )
			break;
		for ( ad2 = ad->child_list ; ad2  ; ad2 = ad2->child_next ) {
			if ( l_strcmp(ad2->dir_name,_path_list[i]) == 0 )
				break;
		}
		if ( ad2 == 0 ) {
			ad2 = _parse_xlaccess(set_server,ad,_path_list[i]);
			if ( ad2 ) {
				ad2->child_next = ad->child_list;
				ad->child_list = ad2;
			}
		}
		if ( ad2 == 0 )
			break;
		ad = ad2;
	}
	d_f_ree(_path_list);
	d_f_ree(_path);
	return ret;
}

AUTH_SERVICE_LIST *
_ap_authentification(int * status,AUTH_SERVICE_LIST * alist,AUTH_CONNECTION_SET * set)
{
AUTH_SERVICE_LIST * ret,**rp,*r;
AUTH_RESULT * res;
int _status;
	*status = ARS_ACCEPT;
	if ( alist == 0 )
		return 0;
	switch ( alist->type ) {
	case ASL_AND:
		ret = 0;
		rp = &ret;
		for ( ; alist ; alist = alist->next ) {
			if ( alist->service ) {
				res = _search_auth_result(set->server_result,alist->service);
				if ( res == 0 ) {
					res = (*alist->service->h.tbl->authentification)
							(set,alist->service,0);
					if ( res ) {
						res->h.next = set->server_result;
						set->server_result = res;
						if ( res->h.status == ARS_DENY )
							goto deny;
					}
				}
				if ( res == 0 ) {
					*rp = new_auth_service_list(alist->service,0,ASL_AND);
					rp = &(*rp)->next;
				}
				else {
					if ( res->h.status == ARS_DENY )
						goto deny;
				}
			}
			else {
				r = _ap_authentification(&_status,alist->list,set);
				if ( r ) {
					if ( r->next )
						*rp = new_auth_service_list(0,r,ASL_AND);
					else {
						*rp = r;
						r->type = ASL_AND;
						rp = &r->next;
					}
					if ( _status == ARS_DENY )
						goto deny;
				}
			}
		}
		return ret;
	case ASL_OR:
		ret = 0;
		rp = &ret;
		for ( ; alist ; alist = alist->next ) {
			if ( alist->service ) {
				res = _search_auth_result(set->server_result,alist->service);
				if ( res ) {
					if ( res->h.status == ARS_DENY )
						continue;
					goto ok;
				}
				res = (*alist->service->h.tbl->authentification)
						(set,r->service,0);
				if ( res ) {
					res->h.next = set->server_result;
					set->server_result = res;
					if ( res->h.status == ARS_DENY )
						goto deny;
					goto ok;
				}
				*rp = new_auth_service_list(alist->service,0,ASL_OR);
				rp = &(*rp)->next;
			}
			else {
				r = _ap_authentification(&_status,alist->list,set);
				if ( r == 0 ) {
					if ( _status == ARS_DENY )
						goto deny;
					goto ok;
				}
				if ( r->next )
					*rp = new_auth_service_list(0,r,ASL_OR);
				else {
					*rp = r;
					r->type = ASL_OR;
					rp = &r->next;
				}
				if ( _status == ARS_DENY )
					goto deny;
			}
		}
		return ret;
	ok:
		free_auth_service_list(ret,0);
		return 0;
	default:
		er_panic("ap");
		return 0;
	}
deny:
	free_auth_service_list(ret,0);
	*status = ARS_DENY;
	return 0;
}


void
_get_client_result(char * pf,AUTH_SET_CLIENT * set)
{
int len;
char * buffer;
char * filename;
DIR * dd;
struct dirent * dr;
STREAM * st;
XL_SEXP * data,*t;
	len = strlen(pf);
	buffer = d_alloc(len+100);
	filename = d_alloc(len+200);
	sprintf(buffer,"%sauthentification/clientresult",pf);
	dd = u_opendir(buffer);
	if ( dd == 0 )
		goto end1;
	set_env(auth_env,l_string(std_cm,"__set"),get_ptr(set,0));
	for ( ; ; ) {
		dr = u_readdir(dd);
		if ( dr == 0 )
			break;
		if ( dr->d_name[0] == '.' )
			continue;
		sprintf(filename,"%s/%s",buffer,dr->d_name);
		st = s_open_file(filename,O_RDONLY);
		if ( st == 0 )
			continue;
		data = init_parse(st,l_string(std_cm,"_get_client_result"),l_string(std_cm,"_get_client_result"));
		set_encoding(data);
		data = cdr(get_el(data,1));
		for ( ; get_type(data) == XLT_PAIR ; data = cdr(data) ) {
			t = eval(auth_env,car(data));
			if ( get_type(t) == XLT_ERROR ) {
				print_sexp(s_stdout,t,0);
				ss_printf("\n");
				break;
			}
		}
	}
	closedir(dd);
end1:	;
	d_f_ree(buffer);
	d_f_ree(filename);
}



void
set_client_result(AUTH_SET_CLIENT * set)
{
char * pf;
//AUTH_RESULT * r,**rp;
	if ( set->enable_client_result )
		return;
	pf = get_preference_path();
	if ( pf == 0 )
		goto next;
	_get_client_result(pf,set);
/*
	rp = &set->preset_result_list;
	for ( ; *rp ; rp = &(*rp)->h.next );
	*rp = r;
*/
next:
	pf = get_peripheral_path();
	_get_client_result(pf,set);
/*
	rp = &set->preset_result_list;
	for ( ; *rp ; rp = &(*rp)->h.next );
	*rp = r;
*/
	set->enable_client_result = 1;
}

AUTH_RESULT_LIST *
_ap_corresponding_result(AUTH_RESULT_LIST ** res_not_permit,AUTH_SET_CLIENT * client_set,AUTH_SERVICE_LIST * lst)
{
AUTH_RESULT_LIST * ret,**rp,*r;
AUTH_RESULT_LIST * rnp,**rnpp,*rnp2;
AUTH_RESULT * res;
	if ( lst == 0 ) {
		*res_not_permit = 0;
		return 0;
	}
	switch ( lst->type ) {
	case ASL_AND:
		ret = 0;
		rp = &ret;
		*res_not_permit = 0;
		rnpp = res_not_permit;
		for ( ; lst ; lst = lst->next ) {
			if ( lst->service ) {
				res = _search_auth_result(client_set->preset_result_list,lst->service);
				if ( res ) {
					r = new_auth_result_list(res,0,ASL_AND);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						if ( res->h.service->h.tbl->client_transaction )
							(*res->h.service->h.tbl->client_transaction)(lst->service,res);
						if ( res->h.status != ARS_SEND_PERMIT )
							goto err1;
						*rp = r;
						rp = &r->next;
					}
					else {
					err1:
						*rnpp = r;
						rnpp = &r->next;
					}
					continue;
				}
				res = _search_auth_result(client_set->required_result_list,lst->service);
				if ( res ) {
					r = new_auth_result_list(res,0,ASL_AND);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						if ( res->h.service->h.tbl->client_transaction )
							(*res->h.service->h.tbl->client_transaction)(lst->service,res);
						if ( res->h.status != ARS_SEND_PERMIT )
							goto err2;
						*rp = r;
						rp = &r->next;
					}
					else {
					err2:
						*rnpp = r;
						rnpp = &r->next;
					}
					continue;
				}
				if ( lst->service->h.tbl ) {
					res = (*lst->service->h.tbl->new_auth_result)(lst->service,0,0);
					res->h.status = ARS_REQUIRED;
					res->h.next = client_set->required_result_list;
					client_set->required_result_list = res;
					r = new_auth_result_list(res,0,ASL_AND);
					if ( res->h.service->h.tbl->client_transaction )
						(*res->h.service->h.tbl->client_transaction)(lst->service,res);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						*rp = r;
						rp = &r->next;
					}
					else {
						*rnpp = r;
						rnpp = &r->next;
					}
				}
			}
			else {
				r = _ap_corresponding_result(&rnp2,client_set,lst->list);
				*rp = r;
				for ( ; *rp ; rp = &(*rp)->next );
				r = new_auth_result_list(0,rnp2,ASL_AND);
				*rnpp = r;
				rnpp = &r->next;
			}
		}
		break;
	case ASL_OR:
		ret = 0;
		rp = &ret;
		
		rnp = 0;
		rnpp = &rnp;
		for ( ; lst ; lst = lst->next ) {
			if ( lst->service ) {
				res = _search_auth_result(client_set->preset_result_list,lst->service);
				if ( res ) {
					r = new_auth_result_list(res,0,ASL_OR);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						*rp = r;
						rp = &r->next;
						free_auth_result_list(rnp);
						rnp = 0;
						break;
					}
					*rnpp = r;
					rnpp = &r->next;
					continue;
				}
				res = _search_auth_result(client_set->required_result_list,lst->service);
				if ( res ) {
					r = new_auth_result_list(res,0,ASL_OR);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						*rp = r;
						rp = &r->next;
						free_auth_result_list(rnp);
						rnp = 0;
						break;
					}
					*rnpp = r;
					rnpp = &r->next;
					continue;
				}
				if ( lst->service->h.tbl ) {
					res = (*lst->service->h.tbl->new_auth_result)(lst->service,0,0);
					res->h.status = ARS_REQUIRED;
					res->h.next = client_set->required_result_list;
					client_set->required_result_list = res;
					r = new_auth_result_list(res,0,ASL_OR);
					if ( res->h.service->h.tbl->client_transaction )
						(*res->h.service->h.tbl->client_transaction)(lst->service,res);
					if ( res->h.status == ARS_SEND_PERMIT ) {
						*rp = r;
						rp = &r->next;
					}
					else {
						*rnpp = r;
						rnpp = &r->next;
					}
				}
			}
			else {
				r = _ap_corresponding_result(&rnp2,client_set,lst->list);
				*rp = r;
				for ( ; *rp ; rp = &(*rp)->next );
				if ( rnp2 == 0 ) {
					free_auth_result_list(rnp);
					rnp = 0;
					break;
				}
				r = new_auth_result_list(0,rnp2,ASL_AND);
				*rnpp = r;
				rnpp = &r->next;
			}
		}
		*res_not_permit = rnp;
		break;
	default:
		er_panic("_ap_corresponding_result");
	}
	return ret;
}


XL_SEXP *
_ap_client_send_sexp(AUTH_RESULT_LIST * res)
{
XL_SEXP * sym,*ret;
	if ( res == 0 )
		return 0;
	sym = n_get_symbol("result-list");
	switch ( res->type ) {
	case ASL_NONE:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"none"));
		break;
	case ASL_AND:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"and"));
		break;
	case ASL_OR:
		set_attribute(sym,l_string(std_cm,"type"),l_string(std_cm,"or"));
		break;
	default:
		er_panic("_ap");
	}
	ret = cons(sym,0);
	for ( ; res ; res = res->next ) {
		if ( res->result ) {
			ret = cons((*res->result->h.service->h.tbl->send_result_info)(res->result),ret);
		}
		else {
			ret = cons(_ap_client_send_sexp(res->list),ret);
		}
	}
	return reverse(ret);
}


XL_SEXP * 
_ap_server_check_path_phase(AUTH_CONNECTION_SET * set,L_CHAR * path,char * operation)
{
XL_SEXP * ret;
AUTH_SERVICE_LIST * alist1,*alist2;
int status;

	alist1 = _exec_authentification(set->server_set,path,operation);
	alist2 = _ap_authentification(&status,alist1,set);
	if ( alist2 == 0 ) {
		if ( status == ARS_DENY ) {
			ret = get_error(
				0,
				0,
				XLE_PROTO_PERMISSION_DENIED,
				l_string(std_cm,"authentification (DENIED)"),
				0);
		}
		else	ret = 0;
	}
	else	ret = _ap_server_send_sexp(alist2);
	free_auth_service_list(alist1,0);
	free_auth_service_list(alist2,0);
	return ret;
}


XL_SEXP *
ap_server_check_path_phase(AUTH_CONNECTION_SET * set,L_CHAR * path,char * operation,int *gc_no)
{
XL_SEXP * ret;
	lock_task(auth_lock);
	set->server_set->auth_gc_no ++;
	*gc_no = set->server_set->auth_gc_no;
	ret = _ap_server_check_path_phase(set,path,operation);
	unlock_task(auth_lock,"ap_server_check_path_phase");
	return ret;
}

XL_SEXP *
_ap_client_get_key(AUTH_RESULT_LIST ** res_notpermit,AUTH_CONNECTION_SET * set,XL_SEXP * service_list)
{
AUTH_SERVICE_LIST * alist1;
AUTH_RESULT_LIST * res;
XL_SEXP * ret;
	set_client_result(set->client_set);
	alist1 = _ap_client_recv_sexp(service_list);
	res = _ap_corresponding_result(res_notpermit,set->client_set,alist1);
	ret = _ap_client_send_sexp(res);
	free_auth_service_list(alist1,0);
	free_auth_result_list(res);
	return ret;
}

XL_SEXP *
ap_client_get_key(AUTH_RESULT_LIST ** res_notpermit,AUTH_CONNECTION_SET * set,XL_SEXP * service_list)
{
XL_SEXP * ret;
	lock_task(auth_lock);
	ret = _ap_client_get_key(res_notpermit,set,service_list);
	unlock_task(auth_lock,"ap_client_get_key");
	return ret;
}

void
_delete_auth_result(AUTH_RESULT ** lst,AUTH_RESULT * target)
{
	for ( ; *lst && *lst != target ; lst = &(*lst)->h.next );
	if ( *lst == 0 )
		return;
	*lst = target->h.next;
	(*target->h.service->h.tbl->free_auth_result)(target,0);
}

AUTH_RESULT *
_search_auth_result(AUTH_RESULT * list,AUTH_SERVICE * s)
{
AUTH_RESULT * ret;

	for ( ret = list ; ret ; ret = ret->h.next )
		if ( ret->h.service == s )
			return ret;
	return ret;
}

AUTH_RESULT *
_search_auth_result_by_name_and_type(AUTH_RESULT * list,L_CHAR * name,AUTH_TABLE * type)
{
AUTH_RESULT * ret;

	for ( ret = list ; ret ; ret = ret->h.next ) {
		if ( name ) {
			if ( l_strcmp(name,ret->h.service->h.service_name) )
				continue;
		}
		if ( type ) {
			if ( ret->h.service->h.tbl != type )
				continue;
		}
		return ret;
	}
	return 0;
}

AUTH_RESULT *
search_auth_result_in_client(L_CHAR * name,AUTH_TABLE * _type,int set_status,int set_target)
{
AUTH_RESULT * ret;
	lock_task(auth_lock);
	ret = _search_auth_result_by_name_and_type(auth_set_client.required_result_list,name,_type);
	if ( ret == 0 )
		ret = _search_auth_result_by_name_and_type(auth_set_client.preset_result_list,name,_type);
	if ( ret )
		ret = (*ret->h.service->h.tbl->new_auth_result)(ret->h.service,ret,0);
	if ( ret->h.status & set_target )
		ret->h.status = set_status;
	unlock_task(auth_lock,"search_auth_result_in_client");
	return ret;
}

void
_set_server_result(AUTH_CONNECTION_SET * set,AUTH_RESULT_LIST * res)
{
AUTH_RESULT_LIST * r;
AUTH_RESULT * rst1;

	for ( r = res ; r ; r = r->next ) {
		if ( r->result ) {
			rst1 = _search_auth_result(set->server_result,r->result->h.service);
			if ( rst1 )
				_delete_auth_result(&set->server_result,rst1);
			rst1 = r->result;
			rst1->h.next = set->server_result;
			set->server_result = rst1;
			(*rst1->h.service->h.tbl->authentification)(set,rst1->h.service,1);
		}
		else {
			_set_server_result(set,r->list);
		}
	}
}

AUTH_RESULT_LIST *
_ap_server_recv_sexp(AUTH_CONNECTION_SET * set,XL_SEXP * s)
{
XL_SEXP * sym,*t;
L_CHAR * _type;
int type;
AUTH_RESULT * r;
AUTH_TABLE * tbl;
AUTH_RESULT_LIST * ret,**rp;
	if ( get_type(s) != XLT_PAIR )
		return 0;
	sym = car(s);
	if ( get_type(sym) != XLT_SYMBOL )
		return 0;
	if ( l_strcmp(sym->symbol.data,l_string(std_cm,"result-list")) )
		return 0;
	_type = get_sf_attribute(sym->symbol.field,l_string(std_cm,"type"));
	if ( _type == 0 )
		type = ASL_NONE;
	else if ( l_strcmp(_type,l_string(std_cm,"none")) == 0 )
		type = ASL_NONE;
	else if ( l_strcmp(_type,l_string(std_cm,"and")) == 0 )
		type = ASL_AND;
	else if ( l_strcmp(_type,l_string(std_cm,"or")) == 0 )
		type = ASL_OR;
	else	type = ASL_NONE;

	s = cdr(s);
	ret = 0;
	rp = &ret;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		t = car(s);
		if ( get_type(t) != XLT_PAIR )
			continue;
		sym = car(t);
		if ( get_type(sym) != XLT_SYMBOL )
			continue;
		if ( l_strcmp(sym->symbol.data,l_string(std_cm,"service")) == 0 ) {
			_type = get_sf_attribute(sym->symbol.field,l_string(std_cm,"type"));
			if ( _type == 0 )
				continue;
			tbl = at_tbl_type_name(n_string(std_cm,_type));
			if ( tbl == 0 )
				continue;
			r = (*tbl->recv_result_info)(set->server_set,t);
			if ( r == 0 )
				continue;
			*rp = new_auth_result_list(r,0,ASL_AND);
			rp = &(*rp)->next;
		}
		else if ( l_strcmp(sym->symbol.data,l_string(std_cm,"result-list")) == 0 ) {
			*rp = new_auth_result_list(0,_ap_server_recv_sexp(set,t),ASL_AND);
			rp = &(*rp)->next;
		}
	}
	return ret;
}

XL_SEXP *
_ap_server_authentification(AUTH_CONNECTION_SET * set,XL_SEXP * result_list,L_CHAR * path,char * operation)
{
AUTH_RESULT_LIST * res;
AUTH_SERVICE_LIST * alist1,*alist2;
XL_SEXP * ret;
int status;


	res = _ap_server_recv_sexp(set,result_list);
	_set_server_result(set,res);
	alist1 = _exec_authentification(set->server_set,path,operation);

	alist2 = _ap_authentification(&status,alist1,set);
	if ( alist2 == 0 ) {
		if ( status == ARS_DENY ) {
			ret = get_error(
				result_list->h.file,
				result_list->h.line,
				XLE_PROTO_PERMISSION_DENIED,
				l_string(std_cm,"authentification (DENIED)"),
				_ap_server_send_sexp(alist2));
		}
		else	ret = 0;
	}
	else {
		ret = get_error(
			result_list->h.file,
			result_list->h.line,
			XLE_PROTO_PERMISSION_DENIED,
			l_string(std_cm,"authentification (DENIED)"),
			_ap_server_send_sexp(alist2));
	}
	free_auth_service_list(alist1,0);
	free_auth_service_list(alist2,0);
	return ret;
}



XL_SEXP *
ap_server_authentification(AUTH_CONNECTION_SET * set,XL_SEXP * result_list,L_CHAR * path,char * operation)
{
XL_SEXP* ret;
	lock_task(auth_lock);
	ret = _ap_server_authentification(set,result_list,path,operation);
	unlock_task(auth_lock,"ap_client_get_key");
	return ret;
}


L_CHAR *
to_service_name(L_CHAR * n)
{
URL u;
L_CHAR * ret;
	memset(&u,0,sizeof(u));
	u.resource = ll_copy_str(n);
	u.db = nl_copy_str(std_cm,"/");
	u.proto = nl_copy_str(std_cm,"SERVICE");
	u.server = ll_copy_str(get_xllisp_site());
	ret = ll_copy_str(get_url_str2(&u));
	free_url(&u);
	return ret;
}

AUTH_CONNECTION_SET *
new_auth_connection_set(XL_INTERPRETER * xli)
{
AUTH_CONNECTION_SET * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->server_set = &auth_set_server;
	ret->client_set = &auth_set_client;
	ret->xli = xli;
	return ret;
}

void
free_auth_connection_set(AUTH_CONNECTION_SET * set)
{
AUTH_RESULT * r;
	lock_task(auth_lock);
	for ( ; set->server_result ; ) {
		r = set->server_result;
		set->server_result = r->h.next;
		r->h.next = 0;
		(*r->h.service->h.tbl->free_auth_result)(r,0);
	}
	unlock_task(auth_lock,"free_auth_connection_set");
}


XL_SEXP *
xl_auth_service(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * service_name;
L_CHAR * service_type;
char * e_msg;
AUTH_SERVICE * sv;
AUTH_TABLE * tbl;
AUTH_SERVICE svv;
L_CHAR * bit;
AUTH_SERVICE_LIST * lst;
AUTH_RESULT * res,**rp;
	service_name = get_sf_attribute(sf,l_string(std_cm,"name"));
	e_msg = "service name required";
	if ( service_name == 0 )
		goto inv_param;
	service_type = get_sf_attribute(sf,l_string(std_cm,"type"));
	e_msg = "service type required";
	if ( service_type == 0 )
		goto inv_param;
	tbl = at_tbl_type_name(n_string(std_cm,service_type));
	e_msg = "service type invalid";
	if ( tbl == 0 )
		goto inv_param;
	if ( get_sf_attribute(sf,l_string(std_cm,"result")) ) {
//		lock_task(auth_lock);

		res = (*tbl->recv_result_info)(0,s);
		if ( res == 0 ) {
			e_msg = "result parse error";
			goto inv_param;
		}
		rp = &auth_set_client.preset_result_list;
		for ( ; *rp ; rp = &(*rp)->h.next );
		*rp = res;

//		unlock_task(auth_lock,"xl_auth_target");
		return 0;

	}

	memset(&svv,0,sizeof(svv));
	svv.h.open_service_name = svv.h.open_service_type = 1;
	bit = get_sf_attribute(sf,l_string(std_cm,"open-service-name"));
	if ( bit )
		svv.h.open_service_name = atoi(n_string(std_cm,bit));
	bit = get_sf_attribute(sf,l_string(std_cm,"open-service-type"));
	if ( bit )
		svv.h.open_service_type = atoi(n_string(std_cm,bit));
	svv.h.service_name = to_service_name(service_name);
	svv.h.tbl = tbl;
	svv.h.description = get_sf_attribute(sf,l_string(std_cm,"description"));
	svv.h.description_url = get_sf_attribute(sf,l_string(std_cm,"description-url"));

//	lock_task(auth_lock);

	sv = (*tbl->parse_info)(&svv,s,sf);
	d_f_ree(svv.h.service_name);

	lst = new_auth_service_list(sv,0,ASL_NONE);
	lst->next = auth_set_server.auth_service_list;
	auth_set_server.auth_service_list = lst;
//	unlock_task(auth_lock,"xl_auth_target");

	return 0;
inv_param:

	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"service"),
		n_get_string(e_msg));
}


XL_SEXP *
xl_auth_target(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * prefix;
char * e_msg;
AUTH_DIR * dr;
AUTH_PREFIX * pf;
AUTH_SERVICE_LIST * lst,*lst2,**lp;
XL_SEXP * t;
L_CHAR * sn;
L_CHAR * operation;
	dr = get_env_work(env);
	if ( dr == 0 )
		goto internal_error;
	prefix = get_sf_attribute(sf,l_string(std_cm,"prefix"));
	operation = get_sf_attribute(sf,l_string(std_cm,"operation"));
		
//	lock_task(auth_lock);
	
	lst2 = 0;
	lp = &lst2;
	s = cdr(s);
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		t = car(s);
		e_msg = "arguments are STRING";
		if ( get_type(t) != XLT_STRING )
			goto type_missmatch;
		sn = to_service_name(t->string.data);
		for ( lst = auth_set_server.auth_service_list ; lst ; lst = lst->next )
			if ( l_strcmp(lst->service->h.service_name,sn) == 0 ) {
				*lp = new_auth_service_list(lst->service,0,ASL_AND);
				lp = &(*lp)->next;
				break;
			}
		d_f_ree(sn);
		if ( lst == 0 ) {
			goto inv_param2;
		}
	}
	
	for ( pf = dr->prefix ; pf ; pf = pf->next )
		if ( l_strcmp(pf->prefix,prefix) == 0 )
			goto ok;
	pf = d_alloc(sizeof(*pf));
	pf->prefix = ll_copy_str(prefix);
	if ( operation )
		pf->operation = ln_copy_str(std_cm,operation);
	else	pf->operation = 0;
	pf->at_list = lst2;
	
	pf->next = dr->prefix;
	dr->prefix = pf;
	goto end;
ok:

	if ( pf->at_list->type == ASL_AND ) {
		pf->at_list = new_auth_service_list(0,pf->at_list,ASL_OR);
	}
	for ( lst = pf->at_list ; lst->next ; lst = lst->next );
	lst->next = new_auth_service_list(0,lst2,ASL_OR);
end:
//	unlock_task(auth_lock,"xl_auth_target");
	return 0;
/*
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"target"),
		n_get_string(e_msg));
*/
inv_param2:
	free_auth_service_list(lst2,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"target"),
		List(n_get_string("undefined service name"),t,-1));
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"target"),
		n_get_string("authentification target internal error (AUTH_DIR)"));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"target"),
		n_get_string(e_msg));
}



XL_SEXP *
xl_auth_transaction(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * ret;
AUTH_RESULT_LIST * notpermit;
XL_INTERPRETER * xli;
	xli = get_my_xli();
	ret = ap_client_get_key(&notpermit,xli->auth_c_set,get_el(s,3));
	free_auth_result_list(notpermit);
	return ret;
}


void
_ap_server_gc(AUTH_CONNECTION_SET * set,int gc_no)
{
AUTH_SERVICE_LIST * list;
	for ( list = set->server_set->auth_service_list; list ; list = list->next ) {
		if ( list->service->h.tbl->gc_service )
			(*list->service->h.tbl->gc_service)(set,list->service,gc_no);
	}
}

void
ap_server_gc(AUTH_CONNECTION_SET * set,int gc_no)
{
	lock_task(auth_lock);
	_ap_server_gc(set,gc_no);
	unlock_task(auth_lock,"ap_server_gc");
}

XL_SEXP *
auth_filepath_passive(XL_SEXP * path,char * operation)
{
XL_SEXP * ret,* ret_result;
XL_INTERPRETER * xli;
XL_SEXP * auth;
int gc_no;

	if ( get_type(path) != XLT_STRING ) {
		return 0;
	}
	xli = get_my_xli();
	if ( xli == 0 )
		return 0;
	ret_result = ret = ap_server_check_path_phase(xli->auth_c_set,path->string.data,operation,&gc_no);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	if ( get_type(ret) == XLT_NULL )
		return 0;
	gc_push(0,0,"check_filepath");
	auth = List(n_get_symbol("auth-transaction"),
			get_integer(1,0),
			path,
			List(n_get_symbol("quote"),ret,-1),
			-1);
//	ret = remote_query(xli->id,gblisp_top_env0,0,auth);
	ret = local_query(gblisp_top_env0,0,auth);
	if ( get_type(ret) != XLT_ERROR ) {
		ret = ap_server_authentification(xli->auth_c_set,ret,path->string.data,operation);
	}
	gc_pop(ret,gc_gb_sexp);
	ap_server_gc(xli->auth_c_set,gc_no);
	return ret;
}

void
_set_authentification_result(AUTH_RESULT * res,XL_SEXP * sv)
{
AUTH_RESULT * ret;
	ret = _search_auth_result_by_name_and_type(auth_set_client.required_result_list,
			res->h.service->h.service_name,res->h.service->h.tbl);
	if ( ret == 0 )
		ret = _search_auth_result_by_name_and_type(auth_set_client.preset_result_list,
				res->h.service->h.service_name,res->h.service->h.tbl);
	if ( ret == 0 )
		return;
	ret->h.status = res->h.status;
	(ret->h.service->h.tbl->set_authentification_result)(ret,sv);
}

void
set_authentification_result(AUTH_RESULT * res,XL_SEXP * sv)
{
	lock_task(auth_lock);
	_set_authentification_result(res,sv);
	unlock_task(auth_lock,"set_authentification_result");
}





