/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"xlerror.h"
#include	"authentification.h"

AUTH_SERVICE *
new_auth_service_fix_user_passwd(AUTH_SERVICE* service)
{
AUTH_SERVICE * ret;
	ret = new_auth_service_header(service,at_tbl(AT_FIX_USER_PASSWD));
	ret->pw.user = ll_copy_str(service->pw.user);
	ret->pw.passwd = ll_copy_str(service->pw.passwd);
	return ret;
}

void
free_auth_service_fix_user_passwd(AUTH_SERVICE * s)
{
	free_auth_service_header(s);
	if ( s->pw.user )
		d_f_ree(s->pw.user);
	if ( s->pw.passwd )
		d_f_ree(s->pw.passwd);
}


AUTH_SERVICE *
parse_info_fix_user_passwd(AUTH_SERVICE* sv,XL_SEXP* s,XL_SYM_FIELD* sf)
{
AUTH_SERVICE * ret;
	ret = new_auth_service_header(sv,at_tbl(AT_FIX_USER_PASSWD));
	ret->pw.user = ll_copy_str(get_sf_attribute(sf,l_string(std_cm,"user")));
	ret->pw.passwd = ll_copy_str(get_sf_attribute(sf,l_string(std_cm,"passwd")));
	return ret;
}

void
server_send_sexp_fix_user_passwd(AUTH_SERVICE*sv,XL_SEXP *sym)
{
}

void
client_recv_sexp_fix_user_passwd(AUTH_SERVICE*sv,XL_SEXP *sym)
{
}

AUTH_RESULT *
authentification_fix_user_passwd(AUTH_CONNECTION_SET * set,AUTH_SERVICE * s,int type)
{
AUTH_RESULT * r;
	if ( type == 0 )
		return 0;
	for ( r = set->server_result ; r ; r = r->h.next ) {
		if ( r->h.service != s )
			continue;
		if ( r->h.status != ARS_NONE )
			return 0;
		r->h.status = ARS_DENY;
		if ( l_strcmp(r->pw.user,s->pw.user) )
			return 0;
		if ( l_strcmp(r->pw.passwd,s->pw.passwd) )
			return 0;
		r->h.status = ARS_ACCEPT;
		return 0;
	}
	return 0;
}

AUTH_RESULT * 
new_auth_result_fix_user_passwd(AUTH_SERVICE * s,AUTH_RESULT * r,int service_copy_flag)
{
AUTH_RESULT * ret;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	if ( service_copy_flag )
		ret->h.service = (*s->h.tbl->new_auth_service)(s);
	else	ret->h.service = s;
	ret->h.status = ARS_NONE;
	if ( r ) {
		*ret = *r;
		if ( s )
			ret->h.service = s;
		ret->pw.user = ll_copy_str(r->pw.user);
		ret->pw.passwd = ll_copy_str(r->pw.passwd);
	}
	return ret;
}

void 
free_auth_result_fix_user_passwd(AUTH_RESULT * res,int service_flag)
{
	if ( service_flag )
		(*res->h.service->h.tbl->free_auth_service)(res->h.service);
	if ( res->pw.user )
		d_f_ree(res->pw.user);
	if ( res->pw.passwd )
		d_f_ree(res->pw.passwd);
	d_f_ree(res);
}

XL_SEXP * 
send_result_info_fix_user_passwd(AUTH_RESULT * r)
{
XL_SEXP * ret, * sym;
	ret = get_result_header_sexp(r);
	sym = car(ret);
	if ( r->pw.user )
		set_attribute(sym,l_string(std_cm,"user"),r->pw.user);
	if ( r->pw.passwd )
		set_attribute(sym,l_string(std_cm,"passwd"),r->pw.passwd);
	return ret;
}

AUTH_RESULT * 
recv_result_info_fix_user_passwd(AUTH_SET_SERVER * set,XL_SEXP * s)
{
AUTH_SERVICE * sv;
XL_SEXP * sym;
AUTH_RESULT pw;
	sym = car(s);
	sv = get_service_header(set,s);
	if ( sv == 0 )
		return 0;
	memset(&pw,0,sizeof(pw));
	pw.pw.user = get_sf_attribute(sym->symbol.field,l_string(std_cm,"user"));
	pw.pw.passwd = get_sf_attribute(sym->symbol.field,l_string(std_cm,"passwd"));
	return new_auth_result_fix_user_passwd(sv,&pw,0);
}

void
set_authentification_result_fix_user_passwd(AUTH_RESULT * res,XL_SEXP *sv)
{
XL_SEXP * sym;
	sym = car(sv);
	if ( res->pw.user )
		d_f_ree(res->pw.user);
	res->pw.user = ll_copy_str(get_sf_attribute(sym->symbol.field,l_string(std_cm,"user")));
	if ( res->pw.passwd )
		d_f_ree(res->pw.passwd);
	res->pw.passwd = ll_copy_str(get_sf_attribute(sym->symbol.field,l_string(std_cm,"passwd")));
}

char ** 
get_result_members_fix_user_passwd(AUTH_RESULT * res)
{
static char * members[] = {"user","passwd",0};
	return members;
}






