/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"u_math.h"
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"


SEM unit_lock;

void
init_unit()
{
DIMENSION dim[DIM];
UNIT_ENV * ue;

	unit_lock = new_lock(LL_UNIT);

	ue = new_uenv();
	set_uenv(gblisp_top_env0,ue);

	n_new_su(ue,D_L,"inch",	10000,254);
	n_new_su(ue,D_L,"feet",	10000,12*254);
	n_new_su(ue,D_L,"yard",	10000,3*12*254);
	n_new_su(ue,D_L,"mm",	1000,1);
	n_new_su(ue,D_L,"cm",	100,1);
	n_new_su(ue,D_L,"m",	1,1);
	n_new_su(ue,D_L,"km",	1,1000);

	n_new_su(ue,D_T,"sec",	60,1);
	n_new_su(ue,D_T,"min",	1,1);
	n_new_su(ue,D_T,"h",	1,60);

	n_new_su(ue,D_W,"mg",	1000,1);
	n_new_su(ue,D_W,"g",	1,1);
	n_new_su(ue,D_W,"kg",	1,1000);

	n_new_su(ue,D_A,"rad",	1,1);
	n_new_su(ue,D_A,"degree",180,M_PI);
	n_new_su(ue,D_A,"'",180*60,M_PI);
	n_new_su(ue,D_A,"''",180*3600,M_PI);

	system_unit_alias(ue);

	name2dim(ue,dim,l_string(std_cm,"m^2"));
	dim[D_L].r = 100;
	n_new_ua(ue,dim,"a");

	name2dim(ue,dim,l_string(std_cm,"cm^3"));
	dim[D_L].r = 1000;
	n_new_ua(ue,dim,"l");
	dim[D_L].r = 100;
	n_new_ua(ue,dim,"dl");

	name2dim(ue,dim,l_string(std_cm,"inch^-1"));
	n_new_ua(ue,dim,"dpi");
	name2dim(ue,dim,l_string(std_cm,"mm^-1"));
	n_new_ua(ue,dim,"dot/mm");
	name2dim(ue,dim,l_string(std_cm,"cm^-1"));
	n_new_ua(ue,dim,"dot/cm");
	name2dim(ue,dim,l_string(std_cm,"m^-1"));
	n_new_ua(ue,dim,"dot/m");
	name2dim(ue,dim,l_string(std_cm,"km^-1"));
	n_new_ua(ue,dim,"dot/km");

	name2dim(ue,dim,l_string(std_cm,"degree^-1"));
	n_new_ua(ue,dim,"dot/degree");
	name2dim(ue,dim,l_string(std_cm,"rad^-1"));
	n_new_ua(ue,dim,"dot/rad");
}






