/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifdef VA2
#include	<varargs.h>
#else
#include	<stdarg.h>
#endif
#include	"xl.h"
#include	"xlerror.h"
#include	"memory_debug.h"


typedef struct ge_by_sym {
	struct ge_by_sym * next;
	L_CHAR * 	attr;
	L_CHAR *	data;
} GE_BY_SYM;



XL_SEXP * v_get_el_by_symbol(
	XL_SEXP * s,
	L_CHAR * sym,
	GE_BY_SYM * cond);

XL_SEXP *
get_el(XL_SEXP * s,int pos)
{
	for ( ; ; ) {
		if ( get_type(s) == XLT_PAIR ) {
			if ( pos == 0 )
				return car(s);
			s = cdr(s);
			pos --;
			continue;
		}
		else {
			return 0;
		}
	}
}

XL_SEXP *
v_get_el_by_symbol(
	XL_SEXP * s,
	L_CHAR * sym,
	GE_BY_SYM * cond)
{
XL_SEXP * el,* tag;
XL_SYM_FIELD * sf;
L_CHAR * data;
GE_BY_SYM * c;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		el = car(s);
		if ( get_type(el) != XLT_PAIR )
			continue;
		tag = car(el);
		if ( get_type(tag) != XLT_SYMBOL )
			continue;
		if ( l_strcmp(tag->symbol.data,sym) )
			continue;
		sf = tag->symbol.field;
		for ( c = cond ; c ; c = c->next ) {
			data = get_sf_attribute(sf,c->attr);
			if ( data == 0 )
				goto not_hit;
			if ( l_strcmp(data,c->data) )
				goto not_hit;
		}
		return el;
	not_hit:
		{}
	}
	return 0;
}

XL_SEXP *
get_el_by_symbol(
	XL_SEXP * s,
	L_CHAR * sym,
	...)
{
GE_BY_SYM * cond, * c;
va_list p;
L_CHAR * attr, * data;
XL_SEXP * ret;

#ifdef VA2
	va_start(p);
#else
	va_start(p,sym);
#endif
	cond = 0;
	for ( ; ; ) {
		attr = va_arg(p,L_CHAR *);
		if ( attr == 0 )
			break;
		data = va_arg(p,L_CHAR *);
		c = d_alloc(sizeof(*c));
		c->attr = attr;
		c->data = data;
		c->next = cond;
		cond = c;
	}
	va_end(p);
	ret = v_get_el_by_symbol(s,sym,cond);
	for ( ; cond ; ) {
		c = cond->next;
		d_f_ree(cond);
		cond = c;
	}
	return ret;
}



typedef struct ge_path {
	struct ge_path *	next;
	L_CHAR *		tag;
	int			cnt;
} GE_PATH;

GE_PATH * _ge_new_path(L_CHAR * path,int len,int cnt);
GE_PATH * _ge_div_path(L_CHAR * path);
void free_ge_path(GE_PATH * p);

GE_PATH *
_ge_new_path(L_CHAR * path,int len,int cnt)
{
GE_PATH * ret;
	ret = d_alloc(sizeof(*ret));
	ret->next = 0;
	ret->tag = d_alloc((len+1)*sizeof(L_CHAR));
	memcpy(ret->tag,path,(len+1)*sizeof(L_CHAR));
	ret->tag[len] = 0;
	ret->cnt = cnt;
	return ret;
}

GE_PATH *
_ge_div_path(L_CHAR * path)
{
GE_PATH * ret, ** rp, * p;
L_CHAR * pp, * qq;
L_CHAR * c;
int len;
int cnt;
	ret = 0;
	rp = &ret;
	for ( ; *path ; ) {
		for ( pp = path ; *pp &&
				*pp != '/' &&
				*pp != '\'' ; pp ++ );
		switch ( *pp ) {
		case 0:
			p = _ge_new_path(path,pp - path,1);
			*rp = p;
			rp = &p->next;
			path = pp;
			continue;
		case '/':
			p = _ge_new_path(path,pp - path,1);
			*rp = p;
			rp = &p->next;
			path = pp+1;
			continue;
		case '\'':
			len = pp - path;
			break;
		default:
			er_panic("_ge_div_path");
		}
		pp ++;
		for ( qq = pp ; *qq &&
				*qq != '/' ; qq ++ );
		c = d_alloc((qq - pp+1)*sizeof(L_CHAR));
		memcpy(c,pp,(qq-pp+1)*sizeof(L_CHAR));
		c[qq-pp] = 0;
		sscanf(n_string(std_cm,c),"%i",&cnt);
		p = _ge_new_path(path,len,cnt);
		*rp = p;
		rp = &p->next;
		d_f_ree(c);
		switch ( *qq ) {
		case 0:
			path = qq;
			break;
		case '/':
			path = qq + 1;
			break;
		default:
			er_panic("_ge_div_path");
		}
	}
	return ret;
}

void
free_ge_path(GE_PATH * p)
{
GE_PATH * p2;
	for ( ; p ; ) {
		p2 = p->next;
		d_f_ree(p->tag);
		d_f_ree(p);
		p = p2;
	}
}

XL_SEXP *
get_el_by_symbol_cnt(L_CHAR * tag,int cnt,XL_SEXP * s)
{
XL_SEXP * p, * sym;
XL_SEXP * ss;
	ss = s;
	for ( ; get_type(s) == XLT_PAIR ; s = cdr(s) ) {
		if ( tag[0] ) {
			p = car(s);
			if ( get_type(p) != XLT_PAIR )
				continue;
			sym = car(p);
			if ( get_type(sym) != XLT_SYMBOL )
				continue;
			if ( l_strcmp(sym->symbol.data,tag) == 0 ) {
				if ( cnt <= 1 )
					return p;
				cnt --;
			}
		}
		else {
			p = car(s);
			if ( cnt <= 1 )
				return p;
			cnt --;
		}
	}
	if ( ss )
		return get_error(
			ss->h.file,
			ss->h.line,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"get_el_c"),
			n_get_string("no object"));
	else	return get_error(
			0,
			0,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"get_el_c"),
			n_get_string("no object"));
}

XL_SEXP *
get_el_c(XL_SEXP * s,L_CHAR * path,L_CHAR * def)
{
GE_PATH * p, * p2;
	p = _ge_div_path(path);
	for ( p2 = p ; p2 ; p2 = p2->next ) {
		s = get_el_by_symbol_cnt(p2->tag,p2->cnt,s);
		if ( get_type(s) == XLT_ERROR )
			break;
	}
	free_ge_path(p);
	if ( get_type(s) == XLT_ERROR && def ) {
		switch ( def[0] ) {
		case '(':
			return 0;
		case '$':
			return get_symbol(&def[1]);
		default:
			return get_string(def);
		}
	}
	return s;
}

