/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"stream.h"
#include	"long_char.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"memory_debug.h"

XL_SEXP * xl_PrintStd();
XL_SEXP * xl_Print();
XL_SEXP * xl_openPrintStd();
XL_SEXP * xl_closePrintStd();
XL_SEXP * (*convert_code_ptr)(XL_SEXP * st,LCZ_SET * set,int flags);


typedef struct st_list {
	struct st_list *	next;
	STREAM *	st;
	int		d;
} ST_LIST;

ST_LIST * __st_list;

int
cmp_ps_str(L_CHAR * f,char * str)
{
int s_len;
	s_len = strlen(str);
	if ( memcmp(f,l_string(std_cm,str),s_len*sizeof(L_CHAR)) )
		return -1;
	switch ( f[s_len] ) {
	case ':':
		return s_len+1;
	case 0:
		return s_len;
	}
	return -1;
}

int
get_ps_flags(L_CHAR * f)
{
int len;
int ret;
	ret = 0;
	for ( ; *f ; f += len ) {
		len = cmp_ps_str(f,"indent");
		if ( len > 0 ) {
			ret |= PF_INDENT;
			continue;
		}
		len = cmp_ps_str(f,"lisp");
		if ( len > 0 ) {
			ret |= PF_LISP;
			continue;
		}
		len = cmp_ps_str(f,"xml");
		if ( len > 0 ) {
			ret |= PF_XML;
			continue;
		}
		len = cmp_ps_str(f,"html");
		if ( len > 0 ) {
			ret |= PF_HTML;
			continue;
		}
		len = cmp_ps_str(f,"text");
		if ( len > 0 ) {
			ret |= PF_TEXT;
			continue;
		}
		return -1;
	}
	return ret;
}


void
init_PrintStd(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"PrintStd"),
		get_func_prim(xl_PrintStd,FO_APPLICATIVE,0,2,2));
	set_env(env,l_string(std_cm,"openPrintStd"),
		get_func_prim(xl_openPrintStd,FO_APPLICATIVE,0,2,2));
	set_env(env,l_string(std_cm,"closePrintStd"),
		get_func_prim(xl_closePrintStd,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_PrintStd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * opt;
int flags;
L_CHAR * file;
L_CHAR * d;
int _d;
STREAM * st;
ST_LIST * std;
XL_SEXP * target;
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	if ( opt ) {
		flags = get_ps_flags(opt);
		if ( flags < 0 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_PARAM,
				l_string(std_cm,"Printstd"),
				list(	n_get_string("invalid parameter (option)"),
					0));
		}
	}
	else	flags = 0;
	d = get_sf_attribute(sf,l_string(std_cm,"d"));
	if ( d == 0 ) {
		file = get_sf_attribute(sf,l_string(std_cm,"file"));
		if ( file == 0 )
			st = s_stdout;
		else	st = s_open_file(n_string(std_cm,file),O_CREAT|O_TRUNC|O_RDWR,0644);
		print_sexp(st,get_el(s,1),PF_RAW_DISABLE|flags);
		s_printf(st,"\n");
	}
	else if ( l_strcmp(d,l_string(std_cm,"stdout")) == 0 ) {
		target = get_el(s,1);
		if ( get_type(target) == XLT_STRING )
			ss_printf("%ls",target->string.data);
		else	print_sexp(s_stdout,target,PF_RAW_DISABLE|flags);
	}
	else {
		_d = atoi(n_string(std_cm,d));
		for ( std = __st_list ; std ; std = std->next )
			if ( std->d == _d )
				break;
		if ( std == 0 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_UNDEF_RESOURCE,
				l_string(std_cm,"Printstd"),
				list(	n_get_string("no stream descripter (attribute d)"),
					0));
		}
		target = get_el(s,1);
		if ( convert_code_ptr )
			target = (*convert_code_ptr)(target,s_get_cm(std->st)->main_code,CBF_ERR_QUESTION);
		if ( get_type(target) == XLT_STRING )
			s_printf(std->st,"%ls",target->string.data);
		else	print_sexp(std->st,target,PF_RAW_DISABLE|flags);
	}
	return 0;
}



XL_SEXP *
xl_openPrintStd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * file;
int mode,flags;
STREAM * st;
int d;
ST_LIST * std;
L_CHAR * encoding;
CODE_METHOD * cm;
	flags = O_CREAT|O_TRUNC|O_RDWR;
	mode = 0644;
	file = get_el(s,1);
	if ( get_type(file) != XLT_STRING )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"openPrintstd"),
			list(	n_get_string("type missmatch"),
				0));
	encoding = get_sf_attribute(sf,l_string(std_cm,"encoding"));
	if ( encoding ) {
		cm = search_cm(n_string(std_cm,encoding));
		if ( cm == 0 ) {
			return get_error(
				s->h.file,
				s->h.line,
				XLE_PROTO_INV_OBJECT,
				l_string(std_cm,"openPrintstd"),
				list(	n_get_string("invalid encoding"),
					0));
		}
	}
	else cm = 0;
	st = s_open_file(n_string(std_cm,file->string.data),flags,mode);
	if ( st == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_OPEN_FILE,
			l_string(std_cm,"openPrintstd"),
			List(	n_get_string("cannot open the file"),
				get_string(file->string.data),
				-1));
	if ( cm )
		s_set_cm(st,cm);
	d = 1;
	for ( std = __st_list ; std ; std = std->next ) {
		if ( std->d >= d )
			d = std->d + 1;
	}
	std = d_alloc(sizeof(*std));
	std->d = d;
	std->st = st;
	std->next = __st_list;
	__st_list = std;
	return get_integer(d,0);
}

XL_SEXP *
xl_closePrintStd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * d;
int _d;
ST_LIST * std, ** stdp;
	d = get_sf_attribute(sf,l_string(std_cm,"d"));
	if ( d == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"closePrintstd"),
			list(	n_get_string("invalid parameter (d)"),
				0));
	_d = atoi(n_string(std_cm,d));
	for ( stdp = &__st_list ; *stdp ; stdp = &(*stdp)->next ) {
		if ( (*stdp)->d == _d )
			break;
	}
	if ( *stdp == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"closePrintstd"),
			list(	n_get_string("no stream descripter (attribute d)"),
				0));
	std = *stdp;
	*stdp = std->next;
	s_close(std->st);
	d_f_ree(std);
	return 0;
}


