/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"

char ** argv;
int argc,v_offset;
XL_SEXP * xl_Arg();
XL_SEXP * xl_ArgOption();

void
init_sh_arg(int _argc,char ** _argv)
{
	argc = _argc;
	argv = _argv;
	for ( v_offset = 1 ; v_offset < argc ; v_offset ++ )
		if ( strcmp(argv[v_offset],"/") == 0 )
			break;
}

void
set_arg(int _argc,char ** _argv,int _v_offset)
{
int i;
	argc = _argc;
	argv = d_alloc(sizeof(char*)*(argc+1));
	for ( i = 0 ; i < argc ; i ++ )
		argv[i] = copy_str(_argv[i]);
	argv[i] = 0;
	v_offset = _v_offset;
}


void
init_Arg(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Arg"),
		get_func_prim(xl_Arg,FO_APPLICATIVE,0,1,2));
	set_env(env,l_string(std_cm,"ArgOption"),
		get_func_prim(xl_ArgOption,FO_APPLICATIVE,0,1,2));
}

XL_SEXP *
xl_Arg(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * arg;
int _arg;
	if ( list_length(s) == 1 ) {
		return get_integer(argc - v_offset,0);
	}
	arg = get_el(s,1);
	switch ( get_type(arg) ) {
	case XLT_ERROR:
		return arg;
	case XLT_INTEGER:
		_arg = arg->integer.data;
		break;
	case XLT_FLOAT:
		_arg = arg->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	_arg += v_offset;
	if ( argc == 0 )
		goto internal_error;
	if ( argc <= _arg || _arg < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_INV_PARAM_LENGTH,
			l_string(std_cm,"Arg"),
			n_get_string("shell argments length over"));
	return get_string(l_string(std_cm,argv[_arg]));
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Arg"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Arg"),
		n_get_string("shell argments initializing is required"));
}



XL_SEXP *
xl_ArgOption(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * arg;
int _arg;
L_CHAR * opt;
int len;
int i;
	if ( list_length(s) > 1 ) {
		arg = get_el(s,1);
		_arg = 1;
	}
	else {
		_arg = 0;
	}
	opt = get_sf_attribute(sf,l_string(std_cm,"name"));
	if ( opt == 0 )
		goto inv_param;
	len = strlen(n_string(std_cm,opt));
	for ( i = v_offset+1 ; i < argc ; i ++ ) {
		if ( memcmp(n_string(std_cm,opt),argv[i],len) )
			continue;
		if ( argv[i][len] == '=' )
			goto ok;
	}
	if ( _arg == 0 )
		goto no_obj;
	return arg;
ok:
	return get_string(l_string(std_cm,&argv[i][len+1]));
/*
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"ArgOption"),
		0);
*/
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"ArgOption"),
		n_get_string("invalid parameter(Attribute option required)"));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"ArgOption"),
		n_get_string("no option that name"));
}


