/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"pdb.h"
#include	"filespace.h"

#include	"change_endian.h"

#include "task.h"


THREAD_BLOCK tb[THREAD_BLOCK_SIZE];


int pdbp_file_header();
int pdbp_2d_draw_header();

int (*status_table[])() = {
	0,
	pdbp_file_header,
	pdbp_2d_draw_header,
	0,
	0,
	0,
	0,
	0,
	0
};



int
pdbp_file_header(PDB * p,
	unsigned int nextofs,
	void * opt,
	PN_FILE_HEADER * fh)
{
	if ( strcmp(fh->version,PDB_VERSION) ) {
		fprintf(stderr,"old invalid version %s\n",fh->version);
		exit(1);
	}
	switch ( fh->type ) {
	case FT_2D_DRAW:
		printf("vector-2d ");
		break;
	case FT_2D_MAP:
		printf("map-2d ");
		break;
	case FT_2D_COORDINATE:
		printf("coordinate-e2d ");
		break;
	default:
		fprintf(stderr,"unrrecognized type (%i)\n",
			fh->type);
		exit(1);
	}
	insert_request(p,nextofs,0);
	return 0;
}

void
dump_data(void * a,int size)
{
int i;
unsigned char * cp;
	cp = a;
	for ( i = 0 ; i < size ; i ++ )
		printf("%02x ",*cp++);
	printf("\n");
}

int
pdbp_2d_draw_header(PDB * p,
	unsigned int nextofs,
	void * opt,
	PN_2D_DRAW_HEADER * d)
{

	printf("%i %f %s ((%f%s %f%s) (%f%s %f%s))\n",
		d->level,
		d->resolution,
		d->unit,
		d->minrect.tl.x,
		d->unit,
		d->minrect.tl.y,
		d->unit,
		d->minrect.br.x,
		d->unit,
		d->minrect.br.y,
		d->unit);
	return 0;
}


int
main(int argc,char ** argv)
{
PDB * p;
int er;

	check_endian(); 
	init_cache(); 
	p = open_pdb(argv[1],O_RDONLY,0,0);
	if ( p == 0 ) {
		fprintf(stderr,"cannot open the file %s\n",
			argv[1]);
		exit(1);
	}
	insert_request(p,0,0);
	for ( ; p->request || p->next_request ; ) {
		er = delete_request(p,status_table,0);
		if ( er < 0 ) {
			fprintf(stderr,"pdb file error %i\n",er);
			break;
		}
	}
	close_pdb(p);
	exit(0);
}
