/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "gm_railroad_lft.h"

void gm_railroad_lft_delete(GM_RAILROAD_LFT_RECORD *record){
	free(record);
}

VPF_RECORD_READER_BEGIN(
	gm_railroad_lft_read, 
	GM_RAILROAD_LFT_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD(f_code);
	VPF_READ_FIELD(exs);
	VPF_READ_FIELD(fco);
	VPF_READ_FIELD(soc);
	VPF_READ_FIELD(tile_id);
	VPF_READ_FIELD(edg_id);
VPF_RECORD_READER_END()

LONG gm_railroad_lft_get_tileid(const GM_RAILROAD_LFT_RECORD *record)
{
	return record->tile_id;
}

LONG gm_railroad_lft_get_edge_id(const GM_RAILROAD_LFT_RECORD *record)
{
	return record->edg_id;
}

void gm_railroad_lft_write_information_tag(FILE *fp, const GM_RAILROAD_LFT_RECORD *record)
{
	fprintf(fp, 
		"<RailRoad>\n"
		"<FACCFeatureCode>%s</FACCFeatureCode>\n"
		"<ExistanceCategory>%hi</ExistanceCategory>\n"
		"<FeatureConfiguration>%hi</FeatureConfiguration>\n"
		"</RailRoad>\n",
		record->f_code, 
		record->exs,
		record->fco);
}
