/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	"xlerror.h"
#include	"xl.h"
#include	"associate.h"
#include	"addrdb.h"
#include	"xl_addrdb.h"

XL_SEXP * xl_AddrdbClose();

void
init_AddrdbClose(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"AddrdbClose"),
		get_func_prim(xl_AddrdbClose, FO_NORMAL, 0, 2, 2));
}

XL_SEXP *
xl_AddrdbClose(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
ADDRDB *db;
	db = addrdb_get_db_from_symbol(env, get_el(s,1));
	
	if(db == NULL)
		goto type_missmatch;

	addrdb_close(db);
	
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"AddrdbClose"),
		n_get_string("type missmatch"));
}

