/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"long_char.h"
#include	"code_method.h"

void
set_latin_own(WCT * w,
	int bitmap,
	int bm_mask,
	L_CHAR lcz,
	L_CHAR lczm)
{
WRITABLE_CODE_TABLE * t;
int i;
	if ( (bitmap & bm_mask) == 0 )
		return;
	t = set_wct(w,lcz,lczm,0,0);
	if ( lczm == LCZM_7b_TYPE ) {
		for ( i = 0x21 ; i <= 0x7f ; i ++ )
			t->tbl[i] = i|lcz;
	}
	else {
		for ( i = 0x20 ; i < 0x7e ; i ++ )
			t->tbl[i] = i|lcz;
		for ( i = 0xa1 ; i <= 0xff ; i ++ )
			t->tbl[i] = i|lcz;
	}
}

void
set_basic_latin(WCT * w,
	int bitmap,
	int bm_mask,
	L_CHAR lcz,
	L_CHAR lczm)
{
WRITABLE_CODE_TABLE * t;
int i;
	if ( (bitmap & bm_mask) == 0 )
		return;
	t = set_wct(w,lcz,lczm,0,0);
	for ( i = 0 ; (i & LCZM_1B_TYPE) == 0  ; i ++ )
		t->tbl[i] = i|lcz;
}

void
wct_latin(WCT * w,int bitmap)
{
	set_basic_latin(w,bitmap,
		LCB_ISO8859_1,
		LCZ_1BC_ISO8859_1,
		LCZM_2B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_2,
		LCZ_1BC_ISO8859_2,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_3,
		LCZ_1BC_ISO8859_3,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_4,
		LCZ_1BC_ISO8859_4,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_5,
		LCZ_1BC_ISO8859_5,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_6,
		LCZ_1BC_ISO8859_6,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_7,
		LCZ_1BC_ISO8859_7,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_8,
		LCZ_1BC_ISO8859_8,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_9,
		LCZ_1BC_ISO8859_9,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_10,
		LCZ_1BC_ISO8859_10,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_13,
		LCZ_1BC_ISO8859_13,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_14,
		LCZ_1BC_ISO8859_14,
		LCZM_1B_TYPE);
	set_latin_own(w,bitmap,
		LCB_ISO8859_15,
		LCZ_1BC_ISO8859_15,
		LCZM_1B_TYPE);
}
