/**********************************************************************
 
	Copyright (C) 2003-
	Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"ft2engine.h"
#include	"encoding_tables.h"


CODE_SCRIPT_TABLE ft2_encoding_table[] = {
	{FT_ENCODING_MS_SYMBOL,
		{0,			LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{FT_ENCODING_UNICODE,
		{0,			LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{FT_ENCODING_SJIS,
		{LCZM_2B_TYPE,		LCC_ERROR},
		{LCZ_2BC_MAC_JAPANESE,	LCZM_ALL},
		0,0xffff},
	{FT_ENCODING_GB2312,
		{LCZ_2BC_GB2312,	LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{FT_ENCODING_BIG5,
		{LCZ_2BC_BIG5,		LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{FT_ENCODING_WANSUNG,
		{LCZ_2BC_WANSUNG,	LCZM_ALL},
		{LCZM_2B_TYPE,		LCC_ERROR},
		0,0xffff},
	{FT_ENCODING_JOHAB,
		{LCZ_2BC_JOHAB,		LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{FT_ENCODING_ADOBE_STANDARD,
		{0,			LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{FT_ENCODING_ADOBE_EXPERT,
		{0,			LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{FT_ENCODING_ADOBE_CUSTOM,
		{0,			LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{FT_ENCODING_ADOBE_LATIN_1,
		{LCZ_1BC_ISO8859_1,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{FT_ENCODING_APPLE_ROMAN,
		{LCZ_1BC_MAC_ROMAN,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{-1,{0,0},{0,0},0,0}
};
