/**********************************************************************
 
	Copyright (C) 2003-
	Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"encoding_tables.h"






NAME_SCRIPT_TABLE bdf_encoding_table[] = {
	{"ascii",
		{LCZ_1BC_ASCII,			LCC_ERROR},
		{LCZM_7b_TYPE,			LCZM_ALL},
		0,0x7f},
	{"iso646",
		{0,				LCC_ERROR},
		{LCZM_7b_TYPE,			LCZM_ALL},
		0,0x7f},
	{"iso8859-1",
		{LCZ_1BC_ISO8859_1,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-2",
		{LCZ_1BC_ISO8859_2,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-3",
		{LCZ_1BC_ISO8859_3,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-4",
		{LCZ_1BC_ISO8859_4,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-5",
		{LCZ_1BC_ISO8859_5,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-6",
		{LCZ_1BC_ISO8859_6,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-7",
		{LCZ_1BC_ISO8859_7,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-8",
		{LCZ_1BC_ISO8859_8,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-9",
		{LCZ_1BC_ISO8859_9,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"iso8859-10",
		{LCZ_1BC_ISO8859_10,		LCC_ERROR},
		{LCZM_1B_TYPE,			LCZM_ALL},
		0,0xff},
	{"unicode-v1.1",
		{LCZ_2BC_UNICODE_v1_1_UN,	LCC_ERROR},
		{LCZM_2B_TYPE,			LCZM_ALL},
		0,0xff},
	{"unicode-v2.0",
		{LCZ_2BC_UNICODE_v2_0_UN,	LCC_ERROR},
		{LCZM_2B_TYPE,			LCZM_ALL},
		0,0xffff},
	{"unicode-v3.0",
		{LCZ_2BC_UNICODE_v3_0_UN,	LCC_ERROR},
		{LCZM_2B_TYPE,			LCZM_ALL},
		0,0xffff},
	{"iso10646-v1.1",
		{LCZ_4BC_ISO10646_v2_0,	LCC_ERROR},
		{LCZM_4B_TYPE,		LCZM_ALL},
		0,0x7fffffff},
	{"iso10646-v2.0",
		{LCZ_4BC_ISO10646_v2_0,	LCC_ERROR},
		{LCZM_4B_TYPE,		LCZM_ALL},
		0,0xff},
	{"iso10646-v3.0",
		{LCZ_4BC_ISO10646_v2_0,	LCC_ERROR},
		{LCZM_4B_TYPE,		LCZM_ALL},
		0,0xff},
	{"iso8859-13",
		{LCZ_1BC_ISO8859_13,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"iso8859-14",
		{LCZ_1BC_ISO8859_14,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"iso8859-15",
		{LCZ_1BC_ISO8859_15,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"viscii",
		{LCZ_1BC_VISCII,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"tcvn5712",
		{LCZ_1BC_TCVN5712,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"tis620",
		{LCZ_1BC_TIS620,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"jisx0201.1976-0",
		{LCZ_1BC_JISX0201,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"jisx0201",
		{LCZ_1BC_JISX0201,	LCC_ERROR},
		{LCZM_1B_TYPE,		LCZM_ALL},
		0,0xff},
	{"jisx0208.1978-0",
		{LCZ_2BC_JISX0208_1978,	LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{"jisx0208.1983-0",
		{LCZ_2BC_JISX0208_1983,	LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},

	{"jisx0208.1990-0",
		{LCZ_2BC_JISX0208_1990,	LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{"jisx0218",
		{LCZ_2BC_JISX0212_1990,	LCC_ERROR},
		{LCZM_2B_TYPE,		LCZM_ALL},
		0,0xffff},
	{0,{0,0},{0,0},0,0}
};
