/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___SIMPLE_ALLOC_H___
#define ___SIMPLE_ALLOC_H___

#define SA_BLOCK_SIZE		1024

typedef struct sa_block {
	struct sa_block *	next;
	int			dummy;
	char			data[SA_BLOCK_SIZE];
} SA_BLOCK;

typedef struct simple_alloc_t {
	SA_BLOCK *		blk;
	int			heap_ptr;
	int			last_alloc;
} SIMPLE_ALLOC_T;

void *
smp_alloc(SIMPLE_ALLOC_T * sat,int size);
void *
smp_realloc(SIMPLE_ALLOC_T * sat,void * ptr,int size);
void
smp_init(SIMPLE_ALLOC_T * sat);
void
free_smp(SIMPLE_ALLOC_T * sat);

#define sat_alloc(x,sat)	((sat) ? smp_alloc(sat,(x)) : d_alloc((x)))
#define sat_realloc(ptr,x,sat)	((sat) ? smp_realloc(sat,(ptr),(x)) : d_re_alloc((ptr),(x)))



#endif

