/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___MX_FORMAT_H___
#define ___MX_FORMAT_H___

#include	"resource.h"
#include	"matrix.h"
#include	"gbview.h"

typedef struct create_param {
	MATRIX *		m;
	int			mode;
	MATRIX_PARAM		p;
} CREATE_PARAM;

typedef struct create_work {
	MATRIX *		mtx;
	int			mode;
	int			active_phase_mode;
	char			pri_active[MI_MODE_MAX];
	int			pri[MI_MODE_MAX][MI_MAX];
	char			phase_active[MI_MODE_MAX];
	XL_SEXP *		phase[MI_MODE_MAX][MI_MAX];
} CREATE_WORK;

typedef struct matrix_param_work {
	MATRIX_PARAM		p;
	CREATE_WORK *		cw;
} MATRIX_PARAM_WORK;
#define MXEM_CREATE	0
#define MXEM_EXIST	1


typedef struct mx_entry {
	struct mx_entry * 	next;
	MX_CACHE		c;
	MX_CACHE_PARAM		p;
	int			mode;
/* in mx_format.h
#define MXEM_CREATE	0
#define MXEM_EXIST	1
*/
	int			id;
} MX_ENTRY;

typedef struct vm_work_header {
	struct vm_work_header *		next;
	struct view_method_tbl *	tbl;
	int				flags;
#define VMWF_NOT_INITIALIZE		0x00000001
} VM_WORK_HEADER;

typedef struct view_method {
	struct view_method *		next;
	struct view_method_tbl *	tbl;
	RESOURCE *			r;
	int				target_channel_nos;
	int *				view_channel;
	MATRIX *			m;
	void *				work;
} VIEW_METHOD;

typedef struct view_method_tbl {
	int			mdt_type;
	MX_STRUCT_BLOCK_TBL *	sb_tbl;
	int			(*vmt_create)(VIEW_METHOD *,MATRIX_NODE *);
	void			(*vmt_free)(VIEW_METHOD*);
	void			(*vmt_draw)(VIEW_METHOD*,GBVIEW_FLAME *,RESOURCE * r,DRAW_WORK *);
	void			(*vmt_point)(VIEW_METHOD*,GBVIEW_FLAME *,RESOURCE * r,GET_POINT_WORK*);
} VIEW_METHOD_TBL;

XL_SEXP * gb_gmxCreate();
XL_SEXP * gb_gmxMatrixParam();
XL_SEXP * gb_gmxPriority();
XL_SEXP * gb_gmxMatrixDimDivide();
XL_SEXP * gb_gmxMatrixBlockSize();
XL_SEXP * gb_gmxMatrixPixelSize();
XL_SEXP * gb_gmxChannelInfo();
XL_SEXP * gb_gmxPhase();
XL_SEXP *
gb_gmxCreate_matrix(CREATE_PARAM * cp,XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
void init_gmx_format(XLISP_ENV *);
void
init_resource_matrix();
int
insert_resource_matrix(RESOURCE * r,int w_flag);
void
gc_resource_matrix();
MX_ENTRY *
search_mx_entry_by_id(int id);
void
close_mx_entry(MX_ENTRY * e);
int
regist_mx_entry(MX_ENTRY * e);
MX_ENTRY *
new_mx_entry(MX_ENTRY * mx_e,MATRIX * m);
MX_ENTRY *
open_mxread(L_CHAR *neturl,L_CHAR * filename,L_CHAR * key,int phase_mode);
void
init_gmx_lib_function(XLISP_ENV * env0,XLISP_ENV * env1);

void init_gmxGetPoint(XLISP_ENV * ,XLISP_ENV * );
void init_gmxCreate(XLISP_ENV * ,XLISP_ENV * );
void init_gmxClose(XLISP_ENV * ,XLISP_ENV * );
void init_gmxPNMStatus(XLISP_ENV * env0,XLISP_ENV * env1);
void init_gmxImportPNM(XLISP_ENV * env0,XLISP_ENV * env1);
void init_gmxExportPNM(XLISP_ENV * env0,XLISP_ENV * env1);
void init_gmxScan(XLISP_ENV * env0,XLISP_ENV * env1);
void init_gmxStatus(XLISP_ENV * env0,XLISP_ENV * env1);
void init_gmxCopy(XLISP_ENV * env0,XLISP_ENV * env1);

extern VIEW_METHOD_TBL **vm_tbl[RT_MAX];

VM_WORK_HEADER *
get_vm_work_header(RESOURCE * r,VIEW_METHOD_TBL * tbl,int size);
VM_WORK_HEADER *
_get_vm_work_header(RESOURCE * r,VIEW_METHOD_TBL * tbl,int size);


#endif

