/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___H_LAYERING_H___
#define ___H_LAYERING_H___

#define HL_CH_PATTERN_INT	1
#define HL_CH_PATTERN_DBL	2
#define HL_CH_DATA		3

#define HL_CH_MAX		4

#define HL_DC_PARAM		((INTEGER64)-1)

#define PTN_TOP_ID		0
#define PTN_PATTERN		1
#define PTN_ID_MAX		2
#define PTN_TOP_DC		3

#define PTN_BASE_RESO		0
#define PTN_ORG			1

#define HL_ESTIMATE_NUTRAL	0
#define HL_ESTIMATE_HIDE	1
#define HL_ESTIMATE_SHOW	2

#define HL_TOTAL_PATTERN	5

typedef struct hl_pattern {
	struct hl_pattern *		next;
	L_CHAR *			url;
} HL_PATTERN;

typedef struct hl_pattern_list {
	struct hl_pattern_list *	next;
	INTEGER64			id;
	INTEGER64 *			top_dc;
	HL_PATTERN *			p;
	int				len;
	double				show_distance;
	double				hide_distance;
} HL_PATTERN_LIST;

HL_PATTERN_LIST *
_convert_pattern_to_loop(MATRIX * m,INTEGER64 fofs,HL_PATTERN * p,HL_PATTERN * target);
HL_PATTERN_LIST *
_convert_pattern_to_id_2(MATRIX * m,INTEGER64 fofs,HL_PATTERN * p,HL_PATTERN * target);
void 	init_h_layering();

#endif


