/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/u_math.h"
#include	"win_flame.h"
#include	"memory_debug.h"
#include	"gbgraph.h"
#include	"viewindex.h"

#define PRI_OFFSET_RATE		20

void ov_default();

void
e2ds_get_weight(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
float weight;
int measure;
int base_measure;
GV_RESOURCE_LIST * rl;
	if ( wf->flags & WFF_LUSTER )
		weight = W_E2D_LUSTER;
	else if ( wf->flags & WFF_POLY )
		weight = W_E2D_POLY;
	else	weight = W_E2D_PLOT;
	measure = (wf->small_rct.br.y - wf->small_rct.tl.y) *
		(wf->small_rct.br.x - wf->small_rct.tl.x);
	base_measure = gf->win_width * gf->win_height;
	rl = search_resource_list(gf,wf->draw,0,1);
	if ( measure > base_measure )
		rl->weight = weight;
	else	rl->weight = weight * measure/base_measure;
}


int
e2ds_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,
	 void * _ix)
{
VPOINT * ix;
int dx,dy;
	ix = _ix;
	dx = to.x - from.x;
	dy = to.y - from.y;
	wf->small_rct.tl.x += dx;
	wf->small_rct.br.x += dx;
	wf->small_rct.tl.y += dy;
	wf->small_rct.br.y += dy;
	wf_move_si(gf,wf,dx,dy);
	return 0;
}


int
e2ds_change(
	WIN_FLAME_TABLE * tbl,
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf)
{
int i;
	switch ( wf->tbl->wf_type ) {
	case WFT_STD:
		wf->small_rct.tl.x = wf->small_rct.tl.y = 0;
		wf->small_rct.br.x = gf->win_width;
		wf->small_rct.br.y = gf->win_height;
		wf->small_resize = 1;
		break;
	case WFT_SMALL:
		break;
	case WFT_PLOT:
		wf->pixels = d_alloc(gf->win_width * gf->win_height 
				* sizeof(long));
		for ( i = 0 ; i < gf->win_width * gf->win_height ; i ++ )
			wf->pixels[i] = C_TRANSPARENT|C_DIRTY;
		wf->small_rct.tl.x = wf->small_rct.tl.y = 0;
		wf->small_rct.br.x = gf->win_width;
		wf->small_rct.br.y = gf->win_height;
		wf->small_resize = 1;
		break;
	default:
		er_panic("e2d_change not support");
	}
	wf->tbl = tbl;
	set_weight(gf,wf);
	return 0;
}




void
e2ds_copy_pixels(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,unsigned long * buf,REAL1 * reso,GB_RECT * r)
{
int x,y,i,index;
unsigned long * dest;
int f;
int width;
int y_index;
int y_index_gf;

	if ( wf->mov_flag )
		return;
	r->tl.y += wf->mov_y;
	r->tl.x += wf->mov_x;
	r->br.y += wf->mov_y;
	r->br.x += wf->mov_x;
	i = 0;
	insert_redraw_gbr(gf,r);
	f = 0;
	width = wf->small_rct.br.x - wf->small_rct.tl.x;
	for ( y = r->tl.y ; y < r->br.y ; y ++ ){
		if ( y < wf->small_rct.tl.y || y >= wf->small_rct.br.y ) {
			i ++;
			continue;
		}
		y_index = (y - wf->small_rct.tl.y)*width;
		y_index_gf = y*gf->win_width;
		for ( x = r->tl.x ; x < r->br.x ; x ++ ) {
			if ( x < wf->small_rct.tl.x || x >= wf->small_rct.br.x ) {
				i ++;
				continue;
			}
			if ( reso[i] < 0 ) {
				i ++;
				continue;
			}
			index = (x - wf->small_rct.tl.x) + y_index;
			dest = &wf->pixels[index];
			*dest = buf[i]|(*dest&C_DIRTY);
			gf->redraw[x + y_index_gf] |= RP_REDRAW;
			i ++;
			f = 1;
		}
	}
	if ( f ) {
//		_wf_set_delay_redraw(gf);
		new_tick((void(*)(int))_wf_set_redraw,0,(int)gf);
	}
}



int
e2ds_redraw_rect(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,GB_RECT *r,int * pri_cnt)
{
int min_x,max_x;
int min_y,max_y;
int xx,yy,i;
unsigned long * buf;
GB_POINT * pt_list;
REAL1 * pt_reso;
int w,h;
MAP_HISTORY * mh;
WIN_FLAME * _wf;
SURP_SET surp;
int id;
int ci_ret;
int width;
int yy_index;
unsigned long * target;

	if ( r->tl.x < wf->small_rct.tl.x ) {
		if ( r->br.x <= wf->small_rct.tl.x )
			return -1;
		r->tl.x = wf->small_rct.tl.x;
	}
	if ( r->tl.x >= wf->small_rct.br.x )
		return -1;
	if ( r->br.x <= wf->small_rct.tl.x )
		return -1;
	if ( r->br.x > wf->small_rct.br.x ) {
		if ( r->tl.x >= wf->small_rct.br.x )
			return -1;
		r->br.x = wf->small_rct.br.x;
	}
	if ( r->tl.y < wf->small_rct.tl.y ) {
		if ( r->br.y <= wf->small_rct.tl.y )
			return -1;
		r->tl.y = wf->small_rct.tl.y;
	}
	if ( r->tl.y >= wf->small_rct.br.y )
		return -1;
	if ( r->br.y <= wf->small_rct.tl.y )
		return -1;
	if ( r->br.y > wf->small_rct.br.y ) {
		if ( r->tl.y >= wf->small_rct.br.y )
			return -1;
		r->br.y = wf->small_rct.br.y;
	}
	if ( r->tl.x < 0 ) {
		if ( r->br.x <= 0 )
			return -1;
		r->tl.x = 0;
	}
	if ( r->tl.x >= gf->win_width )
		return -1;
	if ( r->br.x <= 0 )
		return -1;
	if ( r->br.x > gf->win_width ) {
		if ( r->tl.x >= gf->win_width )
			return -1;
		r->br.x = gf->win_width;
	}
	if ( r->tl.y < 0 ) {
		if ( r->br.y <= 0 )
			return -1;
		r->tl.y = 0;
	}
	if ( r->tl.y >= gf->win_height )
		return -1;
	if ( r->br.y <= 0 )
		return -1;
	if ( r->br.y > gf->win_height ) {
		if ( r->tl.y >= gf->win_height )
			return -1;
		r->br.y = gf->win_height;
	}
	min_x = r->br.x;
	min_y = r->br.y;
	max_x = r->tl.x;
	max_y = r->tl.y;


	wf_lock(gf);


/*
	if ( _check_exit_flame(gf) ) {
		wf_unlock(gf);
		return -3;
	}
*/
	if ( wf->flags & WFF_RESIZE ) {
		wf_unlock(gf);
		return -2;
	}
/*
	for ( td = wf->next ; td ; td = td->next )
		if ( td->draw->c.ov->h.filter == ov_default )
			break;
*/
	width = wf->small_rct.br.x - wf->small_rct.tl.x;
	for ( yy = r->tl.y ; yy < r->br.y ; yy ++ ) {
		yy_index = (yy - wf->small_rct.tl.y) * width;
		for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ){
			if ( !(wf->pixels[yy_index + xx - wf->small_rct.tl.x]&C_DIRTY) )
				continue;
/*
			if ( td &&
				!(td->pixels[yy*gf->win_width + xx]
					& C_TRANSPARENT) )
				continue;
*/
			if ( min_x > xx )
				min_x = xx;
			if ( min_y > yy )
				min_y = yy;
			if ( max_x < xx+1 )
				max_x = xx+1;
			if ( max_y < yy+1 )
				max_y = yy+1;
		}
	}
	if ( max_x < min_x ) {
		wf_unlock(gf);
		return -1;
	}
	r->tl.x = min_x;
	r->tl.y = min_y;
	r->br.x = max_x;
	r->br.y = max_y;
	wf->mov_x = 0;
	wf->mov_y = 0;
	wf->mov_flag = 0;

	w = r->br.x - r->tl.x;
	h = r->br.y - r->tl.y;
	pt_list = d_alloc(w*h*sizeof(GB_POINT));
	pt_reso = d_alloc(w*h*sizeof(REAL1));
	buf = d_alloc(w*h*sizeof(long));
	i = 0;



	for ( yy = r->tl.y ; yy < r->br.y ; yy++ ) {
		yy_index = (yy - wf->small_rct.tl.y) * width;
		for ( xx = r->tl.x ; xx < r->br.x ; xx ++ ) {
			pt_list[i].x = xx;
			pt_list[i].y = yy;
			target = &wf->pixels[yy_index + xx - wf->small_rct.tl.x];
			if ( !((*target)&C_DIRTY) ) {
				pt_reso[i] = -1;
				i ++;
				continue;
			}
			(*target) &= ~C_DIRTY;
			pt_reso[i] = gf->flame_base_resolution;
			buf[i] = C_TRANSPARENT;
			i ++;	
		}	
	}
	mh = add_mh(&gf->flame_base_display_map,wf->mh);

/*
map_test(pt_list,pt_reso,w,w*h,"e2d-1");
ss_printf(">>e2d-1\n");
*/
//ss_printf("MAP LEN 2 = %i\n",map_history_length(mh));

	if ( wf->flags & WFF_LUSTER )
		map_from_flame(mh,pt_list,pt_reso,w*h);

/*
ss_printf(">>e2d-1-end\n");
if ( map_test(pt_list,pt_reso,w,w*h,"e2d-2") )
map_test_trace(mh);
*/

	set_surp(&surp,r,gf->flame_base_resolution);
	map_from_flame(mh,surp.ptr,surp.reso,SURP_NOS);
	id = wf->id;
	wf_unlock(gf);


	ci_ret = cache_image(
		gf,
		wf->id,wf->draw,pt_list,pt_reso,buf,
		w*h,r,mh,&surp,1,
		WFF_PLOT_DIRTY|WFF_LUSTER_DIRTY);

	wf_lock(gf);
	_wf = _get_wf_ptr(gf,id);
	if ( _wf != wf )
		goto end;
	if ( wf->flags & (WFF_FREE|WFF_FREE_OUTLIST) )
{ss_printf("FREE=RETURN-1\n");
		goto end;
}

	if ( !(ci_ret & WFF_DRAW) )
		(*pri_cnt) ++;

	if ( wf->flags & WFF_RESIZE ) {
		d_f_ree(buf);
		d_f_ree(pt_list);
		d_f_ree(pt_reso);
		free_mh(mh);
		wf_unlock(gf);
		return -2;
	}
	e2ds_copy_pixels(gf,wf,buf,pt_reso,r);

	if ( wf->mov_flag )
		wf_free_si(wf);
	else	regulate_si(wf);

end:
	wf_unlock(gf);
	d_f_ree(buf);
	d_f_ree(pt_list);
	d_f_ree(pt_reso);
	free_mh(mh);
	wf_set_delay_redraw_exec(gf);
	return 0;
}



extern int spiral_count;

typedef struct redraw_pixel {
	int		w;
	int		h;
	int		st_w;
	int		st_h;
	int		rdm;
	int		delta[4];
} REDRAW_PIXEL;

void set_redraw_pixel(REDRAW_PIXEL*rp,GBVIEW_FLAME * gf);

void
e2ds_set_redraw_pixel(REDRAW_PIXEL*rp,GBVIEW_FLAME * gf)
{
double unit;
	unit = sqrt(((double)DL_PITCH)*DL_PITCH/
		    (gf->win_width*gf->win_height));
	rp->w = unit*gf->win_width;
	rp->h = unit*gf->win_height;
	rp->st_w = gf->win_width/2 - rp->w/2;
	rp->st_h = gf->win_height/2 - rp->h/2;
	
}

int
e2ds_inc_xy(int * x,int * y)
{
	if ( (*x) == 0 && (*y) == 0 )
		goto home;
	if ( (*y) < 0 && -(*y) >= (*x) && (*x) > (*y) ) {
		(*x) --;
		return 0;
	}
	if ( (*x) < 0 && (*x) <= (*y) && (*y) < -(*x) ) {
		(*y) ++;
		return 0;
	}
	if ( (*y) > 0 && -(*y) <= (*x) && (*x) < (*y) ) {
		(*x) ++;
		return 0;
	}
	/* if ( x > 0 && -x >= y && y > x ) */
	(*y) --;
	if ( (*x) == -(*y) )
		goto home;
	return 0;
home:
	(*x) ++;
	(*y) --;
	return 1;
}


void
draw_rect_rr(GBVIEW_FLAME * gf,GB_RECT r,unsigned long col)
{
int x,y;
	if ( r.tl.x < 0 )
		r.tl.x = 0;
	if ( r.tl.x >= gf->win_width )
		return;
	if ( r.tl.y < 0 )
		r.tl.y = 0;
	if ( r.tl.y >= gf->win_height )
		return;
	if ( r.br.x >= gf->win_width )
		r.br.x = gf->win_width;
	if ( r.br.x < 0 )
		return;
	if ( r.br.y >= gf->win_height )
		r.br.y = gf->win_height;
	if ( r.br.y < 0 )
		return;
	r.br.x --;
	r.br.y --;
	
	x = r.tl.x;
	for ( y = r.tl.y ; y <= r.br.y ; y ++ ) {
		gf->redraw_plane[x + y*gf->win_width] = col;
	}
	x = r.br.x;
	for ( y = r.tl.y ; y <= r.br.y ; y ++ ) {
		gf->redraw_plane[x + y*gf->win_width] = col;
	}
	y = r.tl.y;
	for ( x = r.tl.x ; x <= r.br.x ; x ++ ) {
		gf->redraw_plane[x + y*gf->win_width] = col;
	}
	y = r.br.y;
	for ( x = r.tl.x ; x <= r.br.x ; x ++ ) {
		gf->redraw_plane[x + y*gf->win_width] = col;
	}
}

int
_e2ds_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int xx,yy;
GB_RECT rr;
int t,l,r,b;
int ret;
int sc;
int pri_cnt;
REDRAW_PIXEL rp;


restart:
	wf_lock(gf);
	sc = 0;
	wf->flags &= ~WFF_RESIZE;
	e2ds_set_redraw_pixel(&rp,gf);
	wf_unlock(gf);
	xx = yy = 0;
	t = l = r = b = 0;
	ret = 0;
	pri_cnt = 0;
	for ( ; ; ) {
		if ( rp.st_h + yy*rp.h < 0 )
			t = 1;
		if ( rp.st_h + yy*rp.h >= gf->win_height )
			b = 1;
		if ( rp.st_w + xx*rp.w < 0 )
			l = 1;
		if ( rp.st_w + xx*rp.w >= gf->win_width )
			r = 1;
		rr.tl.x = rp.st_w + xx*rp.w;
		rr.tl.y = rp.st_h + yy*rp.h;
		rr.br.x = rr.tl.x + rp.w;
		rr.br.y = rr.tl.y + rp.h;
/*
ss_printf("** %i(%x) ** xx %i %i %i %i %i %i\n",get_tid(),wf->flags,
xx,yy,t,b,l,r);
*/


		switch ( e2ds_redraw_rect(gf,wf,&rr,&pri_cnt) ) {
		case 0:
			ret = 1;
		case -1:
			break;
		case -2:
			goto restart;
		case -3:
			ret = 2;
			goto end;
		default:
			er_panic("aaa");
		}
		if ( wf->flags & WFF_FREE ) {
			ret = 0;
			goto end;
		}
		if ( e2ds_inc_xy(&xx,&yy) ) {
			if ( t && b && l && r )
				break;
		}
		sc ++;
	}
end:
	if ( sc )
		_set_pri_adj(gf,wf,pri_cnt*PRI_OFFSET_RATE/sc);
	else	_set_pri_adj(gf,wf,pri_cnt);

	return ret;
}

int
e2ds_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
int flags;
	ret = 0;

	wf_lock(gf);
	set_weight(gf,wf);
	flags = wf->flags;
	if ( wf->flags & (WFF_POLY_DIRTY|WFF_LUSTER_DIRTY) ) {
		wf->flags &= ~(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		wf_unlock(gf);
		if ( _e2ds_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_POLY_DIRTY|WFF_LUSTER_DIRTY);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	wf_lock(gf);
	if ( wf->flags & WFF_PLOT_DIRTY ) {
		wf->flags &= ~(WFF_PLOT_DIRTY|WFF_RESIZE);
		wf_unlock(gf);
		if ( _e2d_p_redraw(gf,wf) == 2 ) {
			ret = 2;
			wf->flags |= flags &
				(WFF_PLOT_DIRTY|WFF_RESIZE);
		}
		else	ret = 1;
	}
	else	wf_unlock(gf);
	return ret;
}

int
e2ds_dirty(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT * r,int flags,int mode)
{
int i;
int x,y;
I_RECT rr;
unsigned long * p;
int f;
int width;
	f = 0;
	if ( r == 0 ) {
		for ( i = 0; i < (wf->small_rct.br.x - wf->small_rct.tl.x)*
				(wf->small_rct.br.y - wf->small_rct.tl.y) ; i ++ )
			wf->pixels[i] |= C_DIRTY;
			f = 1;
	}
	else {
		if ( r->tl.x < wf->small_rct.tl.x )
			rr.tl.x = wf->small_rct.tl.x;
		else if ( r->tl.x >= wf->small_rct.br.x )
			return 0;
		else	rr.tl.x = r->tl.x;
		if ( r->tl.y < wf->small_rct.tl.y )
			rr.tl.y = wf->small_rct.tl.y;
		else if ( r->tl.y >= wf->small_rct.br.y )
			return 0;
		else	rr.tl.y = r->tl.y;
		if ( r->br.x >= wf->small_rct.br.x )
			rr.br.x = wf->small_rct.br.x;
		else if ( r->br.x < wf->small_rct.tl.x )
			return 0;
		else	rr.br.x = r->br.x;
		if ( r->br.y >= wf->small_rct.br.y )
			rr.br.y = wf->small_rct.br.y;
		else if ( r->br.y < wf->small_rct.tl.y )
			return 0;
		else	rr.br.y = r->br.y;

		width = wf->small_rct.br.x - wf->small_rct.tl.x;
		for ( y = rr.tl.y ; y < rr.br.y ; y ++ ) {
			p = &wf->pixels[(y - wf->small_rct.tl.y)*width + rr.tl.x - wf->small_rct.tl.x];
			for ( x = rr.tl.x ; x < rr.br.x ; x ++ , p ++ ) {
				*p |= C_DIRTY;
				f = 1;
			}
		}
	}
/*
	wf->rd_mode = mode;
*/
	if ( f ) {
		wf->flags |= flags & WFF_DIRTY &
			wf_get_dirty_mask(wf->flags);
		_wakeup_wf(gf,wf);
	}
	return 0;
}

/***/
int
e2ds_overlay(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a)
{
	a->src = wf->pixels;
	a->s_x = a->d_x - wf->small_rct.tl.x;
	a->s_y = a->d_y - wf->small_rct.tl.y;
	a->s_w = wf->small_rct.br.x - wf->small_rct.tl.x;
	a->s_h = wf->small_rct.br.y - wf->small_rct.tl.y;
	(*wf->draw->c.ov->h.filter)
			(wf->draw->c.ov,a);

	return 0;
}

int
e2ds_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
unsigned long * target;
I_RECT new_rct;
int * ptr;
int x,y;
int xx,yy;
int ix;
int * ptr_y,* ptr_x;
unsigned long * t_ptr;
int width,height;

	wf_free_si(wf);

	new_rct.tl.x = new_rct.tl.y = 0;
	new_rct.br.x = new_rct.br.y = -1;
	
	ptr = ix_x;
	for ( x = 0 ; x < gf->win_width ; x ++ , ptr ++ ) {
		ix = *ptr;
		if ( ix < 0 )
			continue;
		if ( ix < wf->small_rct.tl.x )
			continue;
		if ( ix >= wf->small_rct.br.x )
			continue;
		if ( new_rct.tl.x > new_rct.br.x ) {
			new_rct.tl.x = x;
			new_rct.br.x = x+1;
		}
		else if ( x < new_rct.tl.x )
			new_rct.tl.x = x;
		else if ( x >= new_rct.br.x )
			new_rct.br.x = x+1;
	}
	ptr = ix_y;
	for ( y = 0 ; y < gf->win_height ; y ++ , ptr ++ ) {
		ix = *ptr;
		if ( ix < 0 )
			continue;
		if ( ix < wf->small_rct.tl.y )
			continue;
		if ( ix >= wf->small_rct.br.y )
			continue;
		if ( new_rct.tl.y > new_rct.br.y ) {
			new_rct.tl.y = y;
			new_rct.br.y = y+1;
		}
		else if ( y < new_rct.tl.y )
			new_rct.tl.y = y;
		else if ( y >= new_rct.br.y )
			new_rct.br.y = y+1;
	}
	
	if ( new_rct.tl.x > new_rct.br.x || new_rct.tl.y > new_rct.br.y )
		goto end;
	
	width = (wf->small_rct.br.x - wf->small_rct.tl.x);
	height = wf->small_rct.br.y - wf->small_rct.tl.y;
	
	target = d_alloc(sizeof(unsigned long)*(new_rct.br.x - new_rct.tl.x)*(new_rct.br.y - new_rct.tl.y));
	ptr_y = &ix_y[new_rct.tl.y];
	t_ptr = target;
	for ( y = new_rct.tl.y ; y < new_rct.br.y ; y ++ , ptr_y ++ ) {
		ptr_x = &ix_x[new_rct.tl.x];
		for ( x = new_rct.tl.x ; x < new_rct.br.x ; x ++ , ptr_x ++ ) {
			if ( *ptr_y < 0 ) {
				t_ptr ++;
				continue;
			}
			if ( *ptr_x < 0 ) {
				t_ptr ++;
				continue;
			}
			yy = (*ptr_y) - wf->small_rct.tl.y;
			xx = (*ptr_x) - wf->small_rct.tl.x;
			if ( yy < 0 || xx < 0 )
				*t_ptr = C_TRANSPARENT|C_DIRTY;
			else if ( yy >= height || xx >= width )
				*t_ptr = C_TRANSPARENT|C_DIRTY;
			else	*t_ptr = wf->pixels[xx + yy * width]|C_DIRTY;
			t_ptr ++;
		}
	}
	
	d_f_ree(wf->pixels);
	wf->pixels = target;
	wf->small_rct = new_rct;
	wf->small_resize = 1;
	wf_check_small(gf,wf);
end:
	e2ds_get_weight(gf,wf);
	wf->flags |= WFF_DIRTY;
	return 0;
}

int
e2ds_resize(GBVIEW_FLAME * gf,WIN_FLAME * wf,int old_width,int old_height)
{
int w_ofs,h_ofs;
	w_ofs = (gf->win_width - old_width)/2;
	h_ofs = (gf->win_height - old_height)/2;
	wf->small_rct.tl.x += w_ofs;
	wf->small_rct.tl.y += h_ofs;
	wf->small_rct.br.x += w_ofs;
	wf->small_rct.br.y += h_ofs;
	wf->small_resize = 1;
	wf_check_small(gf,wf);
	return 0;
}


int
e2ds_rotate(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT * ix)
{
I_RECT new_rct;
unsigned long * target;

	target = index_move_small(&new_rct,
		wf->pixels,wf->small_rct,
		(I_POINT*)ix,
		gf->win_width,gf->win_height,
		C_TRANSPARENT|C_DIRTY,
		C_DIRTY);

	d_f_ree(wf->pixels);
	wf->pixels = target;
	wf->small_rct = new_rct;
	wf->small_resize = 1;

	wf_check_small(gf,wf);
	wf_free_si(wf);
	e2ds_get_weight(gf,wf);
	if ( wf->flags & WFF_LUSTER )
		wf->flags |= WFF_LUSTER_DIRTY;
	if ( wf->flags & WFF_POLY )
		wf->flags |= WFF_POLY_DIRTY;
	if ( wf->flags & WFF_PLOT )
		wf->flags |= WFF_PLOT_DIRTY;
	return 0;
}

I_RECT
get_drawrect(GBVIEW_FLAME* gf,GB_RECT r,float rate)
{
I_RECT ret;
GB_POINT center;
REAL1 rw,rh;
	center = p_avg(r.tl,r.br);
	rw = center.x - r.tl.x;
	rh = center.y - r.tl.y;
	if ( rw > 2*gf->win_width )
		rw = 2*gf->win_width;
	if  (rh > 2*gf->win_height )
		rh = 2*gf->win_height;
	rw = rw*rate;
	rh = rh*rate;
	r.tl.x = center.x - rw;
	r.br.x = center.x + rw;
	r.tl.y = center.y - rh;
	r.br.y = center.y + rh;
	
	if ( rw > 0x20000000 )
		rw = 0x20000000;
	if ( rh > 0x20000000 )
		rh = 0x20000000;
	
	if ( r.tl.x < (REAL1)(-0x7fffffff) ) {
	hem1:
		ret.tl.x = 0x7fffffff;
		ret.br.x = ret.tl.x + 2*rw;
	}
	else if ( r.tl.x > (REAL1)0x7fffffff ) {
	hem2:
		ret.br.x = 0x7fffffff;
		ret.tl.x = ret.br.x - 2*rw;
	}
	else if ( r.br.x < (REAL1)(-0x7fffffff) ) {
		goto hem1;
	}
	else if ( r.br.x > (REAL1)(0x7fffffff) ) {
		goto hem2;
	}
	else {
		ret.tl.x = floor(r.tl.x);
		ret.br.x = ceil(r.br.x);
	}
	
	if ( r.tl.y < (REAL1)(-0x7fffffff) ) {
	hem3:
		ret.tl.y = 0x7fffffff;
		ret.br.y = ret.tl.y + 2*rh;
	}
	else if ( r.tl.y > (REAL1)(0x7fffffff) ) {
	hem4:
		ret.br.y = 0x7fffffff;
		ret.tl.y = ret.br.y - 2*rh;
	}
	else if ( r.br.y < (REAL1)(-0x7fffffff) ) {
		goto hem3;
	}
	else if ( r.br.y > (REAL1)(0x7fffffff) ) {
		goto hem4;
	}
	else {
		ret.tl.y = floor(r.tl.y);
		ret.br.y = ceil(r.br.y);
	}

if ( ret.tl.x < -2000000000 )
ss_printf("STOP\n");

	return ret;
}

int
copy_small_rect(unsigned long * dest,I_RECT dest_rct,unsigned long * src,I_RECT src_rct)
{
int x,y;
int width;
unsigned long * d_ptr;
int ret;

if ( dest_rct.tl.y < -0x800000 )
ss_printf("copy_small_rect");
	ret = 0;
	d_ptr = dest;
	width = src_rct.br.x - src_rct.tl.x;
	for ( y = dest_rct.tl.y ; y < dest_rct.br.y ; y ++ ) {
		for ( x = dest_rct.tl.x ; x < dest_rct.br.x ; x ++ , d_ptr ++ ) {
			if ( y < src_rct.tl.y )
				goto no_data;
			else if ( y >= src_rct.br.y )
				goto no_data;
			else if ( x < src_rct.tl.x )
				goto no_data;
			else if ( x >= src_rct.br.x )
				goto no_data;
			*d_ptr = src[(x-src_rct.tl.x) + (y-src_rct.tl.y)*width];
			continue;
		no_data:
			*d_ptr = C_TRANSPARENT|C_DIRTY;
			ret = 1;
		}
	}
	return ret;
}

void
e2ds_setup_drawrect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT r,float rate)
{
I_RECT rct;
unsigned long * pixels;
int dirty;
int x,y;
unsigned long * ptr;
	rct = get_drawrect(gf,r,rate);
	ptr = wf->pixels;
	for ( y = wf->small_rct.tl.y ; y < wf->small_rct.br.y ; y ++ ) {
		for ( x = wf->small_rct.tl.x ; x < wf->small_rct.br.x ; x ++ ) {
			if ( *ptr++ != C_TRANSPARENT ) {
				if ( x < rct.tl.x )
					rct.tl.x = x;
				if ( x >= rct.br.x )
					rct.br.x = x+1;
				if ( y < rct.tl.y )
					rct.tl.y = y;
				if ( y >= rct.br.y )
					rct.br.y = y+1;
			}
		}
	}
	if ( rct.tl.x == wf->small_rct.tl.x &&
			rct.tl.y == wf->small_rct.tl.y &&
			rct.br.x == wf->small_rct.br.x &&
			rct.br.y == wf->small_rct.br.y )
		goto small;
	if ( rct.br.x - rct.tl.x >= gf->win_width ||
			rct.br.y - rct.tl.y >= gf->win_height ) {
		wf->flags &= ~WFF_TO_SMALL;
		wf->flags |= WFF_TO_STD;
		return;
	}
	pixels = d_alloc(sizeof(long)*(rct.br.x - rct.tl.x)*(rct.br.y - rct.tl.y));
	dirty = copy_small_rect(pixels,rct,wf->pixels,wf->small_rct);
	d_f_ree(wf->pixels);
	wf->pixels = pixels;
	wf->small_rct = rct;
	
	if ( dirty ) {
		if ( wf->flags & WFF_LUSTER )
			wf->flags |= WFF_LUSTER_DIRTY;
		if ( wf->flags & WFF_POLY )
			wf->flags |= WFF_POLY_DIRTY;
	}

small:
	wf->flags |= WFF_TO_SMALL;
	wf->flags &= ~WFF_TO_STD;
}




