/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_X11_H___
#define ___V_X11_H___


#define NeedFunctionPrototypes 1
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#include <sys/errno.h>
#include "machine/msequence.h"
#include "machine/include.h"

#include	"long_char.h"

typedef I_POINT VPOINT;
typedef I_RECT VRECT;

typedef struct verror {
	int		err1;
	int		err2;
} VERROR;

typedef struct vtext_ind {
	int			mode;
#define VT_TRANS		1
#define VT_BACKGROUND		2
	LC_WRITING_STYLE *	ws;
 	int			size;
	int			dir;
	int			st_x;
	int			st_y;
	L_CHAR *		data;
	int			length;
	unsigned long		color;
	unsigned long		background;
	VRECT			minrect;
} VTEXT_IND;


typedef struct vobj_header {
	int			type;
	union vobject *		next;
	struct vwindow *	win;
	void			(*handler)(/* obj, cmd, ...*/);
	/* cmd */
#define VE_REDRAW	1
#define VE_BUTTON	2
#define VE_MAX		3

#define VES_BUTTON_PRESS	1
#define VES_BUTTON_RELEASE	2
#define VES_BUTTON_MOTION	3
} VOBJ_HEADER;

typedef struct vimage {
	VOBJ_HEADER		_h;
	char *			buf_8;
	short *			buf_16;
	long *			buf_32;
	int			x;
	int			y;
	int			w;
	int			h;
	int			w_border;

	int			select_flag;
		/* 1 --> select */
		/* 0 --> not select */
	VPOINT			select[2];

	XImage *		ximage;
} VIMAGE;

typedef struct vtext {
	VOBJ_HEADER		_h;
	VTEXT_IND		in;
} VTEXT;

typedef union vobject {
	VOBJ_HEADER	header;
#define VT_IMAGE	1
#define VT_TEXT		2
	VIMAGE		vimage;
	VTEXT		vtext;
} VOBJECT;


typedef struct v_map_tbl {
	unsigned int *		map[3];
#define GB2M_R	0
#define GB2M_G	1
#define GB2M_B	2
	int			pixel_bits;

	char			red_shift;
	char			green_shift;
	char			blue_shift;
	unsigned long		red_mask;
	unsigned long		green_mask;
	unsigned long		blue_mask;
	unsigned long		red_mul;
	unsigned long		green_mul;
	unsigned long		blue_mul;
} V_MAP_TBL;


typedef struct vfont_list {
	char *		name;
	XFontStruct *	fs;
	int		size;
} VFONT_LIST;

typedef struct vfont {
	char *		fontname;
	VFONT_LIST *	vlist;
	int		vlist_len;
} VFONT;

typedef struct vdisplay {
	/* machine indipendent members */

	int			(*err_handler)();
	struct vwindow *	win_list;
	void			(*handler[VE_MAX])();
	WCT *			wct;

	/* machine dipendent members */

	struct vdisplay *	next;
	Display *		d;
	Window			r; /* root window */
	Visual *		visual;
	Colormap		cmap;
	V_MAP_TBL		gb2m_map;

	int			depth;

	struct vwindow *	for_string_pic;

	LC_FONT_ENGINE		fe;
} VDISPLAY;


#define GB2MCOLOR(tbl,f)	\
	((tbl).map[0][(f)&COL_MASK]|			\
		(tbl).map[1][((f)>>COL_BIT)&COL_MASK]|	\
		(tbl).map[2][((f)>>(COL_BIT*2))&COL_MASK])

#define GB2MCOLOR_D(d,f)	GB2MCOLOR(d->gb2m_map,f)

#define MCOLOR2GB(r,g,b,tbl,f)	\
	{							\
		(r) = ((((unsigned long)(f))&(tbl).red_mask)	\
				>>(tbl).red_shift)		\
				*(tbl).red_mul;			\
		(g) = ((((unsigned long)(f))&(tbl).green_mask)	\
				>>(tbl).green_shift)		\
				*(tbl).green_mul;		\
		(b) = ((((unsigned long)(f))&(tbl).blue_mask)	\
				>>(tbl).blue_shift)		\
				*(tbl).blue_mul;		\
	}


typedef struct vwindow {
	struct vwindow *	next;
	VOBJECT *		obj_list;

	VDISPLAY *		d;
	Window 			w;
	GC			gc;
} VWINDOW;

typedef struct vwindow_attributes {
	int			x;
	int			y;
	int			w;
	int			h;
} VWINDOW_ATTRIBUTES;

typedef struct v_open_win_s {
	VWINDOW * ret;
	VERROR * err;
	VDISPLAY * d;
	int x;
	int y;
	int w;
	int h;
	int map;
} V_OPEN_WIN_S;

VWINDOW * _get_vwin(VDISPLAY *,Window);

XFontStruct *
_v_get_fs(VFONT_LIST * vlist);



/* errors */
#ifndef E_OK
#define E_OK		0
#define E_SYS		(-1)
#endif
#define E_VMATCH	(-2)
#define E_PARAM		(-3)

VDISPLAY *
v_open_disp(VERROR * err);

VWINDOW *
v_open_win(VERROR * err,VDISPLAY * d,int x,int y,int w,int h);
void
v_get_window_attributes(VERROR *,VWINDOW_ATTRIBUTES *,VWINDOW *);
void v_clear_window_content(VERROR * err, VWINDOW *win);

VOBJECT *
v_create_image(VERROR * err,VWINDOW * win,int x,int y,int w,int h);
void
v_set_image(VERROR * err,VOBJECT * obj,int x,int y,int w,int h);
int
v_image_minrect(VRECT * ,VOBJECT *);
void *
v_get_and_new_image(int *,VOBJECT *);

VOBJECT *
v_create_text(VERROR * err,VWINDOW * win,
		unsigned long,unsigned long,
	    	LC_WRITING_STYLE *,
		int,int,
		int,int,L_CHAR*,int);
int
v_set_text(VERROR *,VOBJECT *,
		unsigned long,unsigned long,
		LC_WRITING_STYLE *,
		L_CHAR *,int);
void
v_move_text(VOBJECT *,int,int);
int
v_text_minrect(VRECT*,VOBJECT*);

int check_inside(VRECT,VPOINT);

void
v_get_string_pic(
	LC_STRING_PIC * p,
	int 		dir,
	LCF_SET *	str,
	int len);

int
v_select_box(VOBJECT * obj,VPOINT st,VPOINT end,int flag);

void
marge_vrect(VRECT *,VRECT *);

void
v_set_display_key(char *);

extern void (*null_handler)();
extern void (*invoke_handler)();

LC_FONT_ENGINE *v_get_font_engine(VOBJECT * );


typedef Bool (*check_func_type) (
	  Display*                 /* display */,
	  XEvent*                  /* event */,
	  XPointer                 /* arg */
	  );          /* predicate */

void _redraw(VWINDOW * win,int x,int y,int w,int h);
void _button(VWINDOW * win,int subtype,int t,int x,int y);
void _null();
void _invoke();

int _v_open_win(V_OPEN_WIN_S * v);

#endif

