/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#pragma once

#include	<LTCPEndpoint.h>
#include	<UNetworkFactory.h>
#include	<LListener.h>
#include	"task.h"

typedef struct EndpointList {
	LTCPEndpoint *		endpoint;
	struct EndpointList *	next;
} EndpointList;

typedef struct ThreadList {
	THREAD			thread;
	 struct ThreadList *	next;
} ThreadList;

typedef class CExceptionStop
{
  public :
				CExceptionStop();
				~CExceptionStop();
  protected :
	static short	depth;
} _EXSTOP;
typedef _EXSTOP *	EXSTOP;

class CServerMaster : public LListener
{
  public : 
					CServerMaster(int * open_port,int base_port,int limit);
	virtual			~CServerMaster(void);
	
	virtual void		ListenToMessage(	MessageT	inMessage,
									void*		ioParam);
	LTCPEndpoint *		AcceptConnection();
	LTCPEndpoint *		GetEP(void) { return mEndpoint; }
	static void			Server_Task(LThread &, void *);
  protected :
	LTCPEndpoint *		mEndpoint;
	EndpointList *		mEndpointList;
	EndpointList *		mEndpointListLast;
	ThreadList *		mThreadList;
	short				mCounter;
	THREAD			mThread;
	SEM				server_master_lock;
	long				signature;
};

void _ExStop(void);
void _ExRevert(void);
void _ExThrow(void);