/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

/************************************

	machine dependent
	task system

*************************************/

#ifndef ___M_TASK_H___
#define ___M_TASK_H___

#ifdef __cplusplus
typedef	class LSimpleThread *	THREAD;
#else
typedef	void *	THREAD;
#endif

#ifdef __cplusplus
typedef struct __d_sem {
	class LSemaphore *	body;
	char *			file;
	int			line;
} __D_SEM;
#else
typedef struct __d_sem {
	void *			body;
	char *			file;
	int			line;
} __D_SEM;
#endif
typedef __D_SEM * D_SEM;


#define THREAD_BLOCK_SIZE	1000

typedef struct sw_hash {
	struct sw_hash *		next;
	unsigned int		key;
	THREAD			thread;
} SW_HASH;

 
typedef union thread_block {
	union thread_block *	next;
	SW_HASH			sw_hash;
} THREAD_BLOCK;



typedef void * TKEY;
int GET_TKEY(TKEY);
int _create_task(void (*func)(TKEY), int data, int priority, char *name,char*,int);

#define xx_create_task(func,data,pri,__f,__l) _create_task(func,data,pri,#func,__f,__l)

#define set_t_msg(a)

void init_thread_block();
void * new_block();
void free_block(void * t);
void sw_init();

void init_test_task();
void test_task(char * str);


/**********************************************
	CHIMERA VERSION 
***********************************************/


typedef struct wd_entry {
	struct wd_entry *	next;
	int			fd;
	int			state;
#define WDS_SAME_FD_WAIT	1
#define WDS_POLLING		2
#define WDS_LOCKED		3
#define WDS_CP_LOCKED		4
#define WDS_SIGNAL		5
#define WDS_CP_SIGNAL		6
	int			type;
	int			tid;
	int			p_events;
	int			p_revents;
} WD_ENTRY;


WD_ENTRY * wait_data_lock(int fd,int type);
#define WDT_READ	1
#define WDT_WRITE	2
#define WDT_CLOSE	4

int wait_data_unlock(WD_ENTRY *);


#define SCHED_SUPER_POLICY	SCHED_OTHER
#define SCHED_POLICY		SCHED_OTHER




#endif
