/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_LaunchWWW();


void
init_LaunchWWW(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"LaunchWWW"),
		get_func_prim(xl_LaunchWWW,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_LaunchWWW(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * arg;
	arg = get_el(s,1);
	if ( get_type(arg) != XLT_STRING )
		goto type_missmatch;
	http_system(0,0,n_string(std_cm,arg->string.data));
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"LaunchWWW"),
		0);
}


