/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	"xlerror.h"
#include	"xl.h"
#include	"netmapper.h"

extern void gc_gb_sexp();
XL_SEXP * xl_Tolerance();
int loading_target;

void
init_Tolerance(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Tolerance"),
		get_func_prim(xl_Tolerance,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Tolerance(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int target;
XL_SEXP * tol;
	target = 0;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"target")) == 0 ) {
			target = atoi(n_string(std_cm,sf->data));
		}
	}
	if ( target == 0 )
		goto invalid_param;
	tol = get_el(s,1);
	switch ( get_type(tol) ) {
	case XLT_INTEGER:
		net_target[target-1].tolerance = tol->integer.data;
		break;
	case XLT_FLOAT:
		net_target[target-1].tolerance = tol->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	return 0;
invalid_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"Tolerance"),
		0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Tolerance"),
		0);
}


