/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_ring.h"


VPF_RECORD_READER_BEGIN(
	ring_record_read, 
	VPF_RING_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD(face_id)
	VPF_READ_FIELD(start_edge)
VPF_RECORD_READER_END()

void ring_record_delete(VPF_RING_RECORD *ring){
	free(ring);
}

VPF_RING_RECORD *vpf_table_get_ring(VPF_TABLE *ring_table, LONG id)
{
	VPF_LIST_ITEM *it;
	VPF_RING_RECORD *r;
	for(it = ring_table->records->head; it; it=it->next){
		r = (VPF_RING_RECORD *)it->data;
		if(r->id == id)
			return r;
	}
	return NULL;

}

void vpf_table_get_rings_by_faceid(VPF_LIST *ret, const VPF_TABLE *ring_table, LONG faceid){
VPF_LIST_ITEM *it;
VPF_RING_RECORD *r;

	if(!ret){
		printf("error: ret is null in vpf_table_get_rings_by_faceid func.");
		return;
	}
	for(it = ring_table->records->head; it; it=it->next){
		r = (VPF_RING_RECORD *)it->data;
		if(r->face_id == faceid){
			vpf_list_push(ret, r);
		}
	}
}

