/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_INLAND_WATER_AFT_H____
#define GM_INLAND_WATER_AFT_H____

#include "vpf_types.h" 
#include "vpf_container.h"
#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	char soc[4];
	char *nam;
	SHORT hyc;
	SHORT tile_id;
	LONG fac_id;
}GM_INLAND_WATER_AFT_RECORD;

void gm_inland_water_aft_delete(GM_INLAND_WATER_AFT_RECORD *record);
BOOL gm_inland_water_aft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_inland_water_aft_get_tileid(const GM_INLAND_WATER_AFT_RECORD *record);
LONG gm_inland_water_aft_get_fac_id(const GM_INLAND_WATER_AFT_RECORD *record);
void gm_inland_water_aft_write_information_tag(FILE *fp, GM_INLAND_WATER_AFT_RECORD *record);

#endif

