/**********************************************************************
 
	Copyright (C) 2003-2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<sys/wait.h>
#include	<sys/time.h>
#include	<sys/types.h>
#include	<sys/param.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<signal.h>
#include	<errno.h>
#include	<semaphore.h>
#include	<pthread.h>
#include	"init.h"
#include	"task.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"machine/chimera.h"
#include	"machine/err.h"


int pri_table[PRI_MAX] = {0,10,20,30,40,50};

sem_t*
new_semaphore()
{
sem_t * s;
char name[16];
static int sem_num;
int i = 0;
	do {
		sprintf(name, "%d-%04i", getpid(), ++sem_num);
		s = sem_open(name, O_CREAT | O_EXCL, 0600, 0);
		i++;
	} while ( s == (sem_t*)SEM_FAILED && i < 10 );
	if ( i == 10 ) {
		perror("new_semaphore");
		printf("name : %s\n", name);
		er_panic("new_semaphore");
	}
	sem_unlink(name);
	sem_trywait(s);
	for ( ; sem_post(s); );
	return s;
}


void
chimera_lock_task(CHIMERA_SEM s,char * file,int line)
{
retry:

	errno = 0;
	if ( sem_wait(s->s) ) {
		if ( errno == EINTR )
			goto retry;
	}
	s->lock_file = file;
	s->lock_line = line;
	s->lock_htid = _get_tid();
}

void
chimera_unlock_task(CHIMERA_SEM s,char *str,char * file,int line)
{
int er;
	s->unlock_file = file;
	s->unlock_line = line;
	s->unlock_htid = _get_tid();
	
	er = 1;
	for ( ; er ; ) {
		er = sem_post(s->s);
	}
}

void chimera_close_lock(CHIMERA_SEM s)
{
	sem_destroy(s->s);
	free(s);
}

CHIMERA_SEM
chimera_new_lock()
{
CHIMERA_SEM s;
	s = malloc(sizeof(*s));
	s->s = new_semaphore();
	return s;
}

int
_sem_getvalue(CHIMERA_SEM s,int * value)
{
	*value = 0;
	return 0;
}


HTID
chimera_get_hard_tid(int tid)
{
HTID ret;
	ret.valid = 1;
	ret.tid = tid;
	return ret;
}



int
chimera_create_task(void (*func)(),int data,int pri)
{
pthread_t tid;
int ret;
void *(*f)();
int * d;
pthread_attr_t tattr;
struct sched_param param;
int policy;


	f = (void *(*)())func;
	d = malloc(sizeof(int));
	*d = data;
/*
	if ( task_cnt >= TASK_NOS_LIMIT ) {
		printf("TASK NOS LIMIT\n");
		return ESYS_AGAIN;
	}
*/

	ret = pthread_attr_init(&tattr);

	pthread_attr_setstacksize(&tattr,0x10000);

	if ( pri < 0 ) {
/*
		policy = SCHED_SUPER_POLICY;
		pri = 0;
*/
		policy = SCHED_POLICY;
		pri = PRI_MAX-1;
	}
	else	policy = SCHED_POLICY;
	ret = pthread_attr_setschedpolicy(&tattr,policy);
	if ( policy != SCHED_OTHER ) {
		pthread_attr_getschedparam(&tattr,&param);
		if ( pri >= PRI_MAX )
			pri = PRI_MAX-1;
		if ( pri < 0 )
			pri = 0;
		param.sched_priority = pri_table[pri];
		ret = pthread_attr_setschedparam(&tattr,&param);
		if ( ret )
			er_panic("create_task(set_schedparam)");
	}
	ret = pthread_attr_setdetachstate(&tattr,PTHREAD_CREATE_DETACHED);
	if ( ret )
		er_panic("create_task(detatch)");
	ret = pthread_create(&tid,&tattr,f,d);
/*
	fprintf(stderr,"tid = %i\n",tid);
*/
	switch ( ret ) {
	case 0:
/*
		fprintf(stderr,"OK\n");
*/
		break;
	case ESYS_AGAIN:
		fprintf(stdout,"EAGAIN %i\n",(int)getpid());
		break;
	case ESYS_INVAL:
		fprintf(stdout,"EINVAL %i\n",(int)getpid());
		break;
	default:
		fprintf(stdout,"default %i\n",(int)getpid());
		break;
	}
	return ret;
}
