/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#include	"stream.h"
#include	"task.h"
#include	"s_buf.h"
#include	"pri_level.h"
#include	"memory_debug.h"
#include	"utils.h"

SBUF_DATA *  get_sbuf_marge_all(STREAM_BUF * sb);
void
s_write_abort_task();

extern SEM stream_lock;
int s_write_wait,s_write_pos;
extern STREAM * stream_list;
int s_write_abort_task_flag;
int s_write_abort_cnt;

int
s_write(STREAM * s,void * data,int len)
{
S_TABLE * tbl;
S_FILE_THREAD t;
int ret;
int pri;
	pri = push_pri(PRI_NETWORK);
	lock_task(stream_lock);
	if ( s == 0 ) {
		unlock_task(stream_lock,"s_write");
		change_pri(0,pri);
		return -1;
	}
	if ( s->h.tbl == 0 ) {
		unlock_task(stream_lock,"s_write");
		change_pri(0,pri);
		return -1;
	}
	tbl = s->h.tbl;
	if ( (tbl->flags & STF_BUF_OUT) ||
			(s->h.wb_flags & STF_BUF_OUT) ) {

		if ( s->h.wb_flags & WBF_ERROR ) {
			ret = -1;
			unlock_task(stream_lock,"s_write");
			change_pri(0,pri);
			return ret;
		}
		copy_in_sbuf(&s->h.write_buf,data,len,SEM_NULL);
		calc_checksum(s,data,len,0);
		ret = len;
		wakeup_task((int)s_write);
		unlock_task(stream_lock,"s_write");
		change_pri(0,pri);
		return ret;
	}
	_s_insert_thread(s,&t);
	
	if ( s->h.write_abort_type ) {
		s->h.write_tid = get_tid();
		s->h.write_in_time = get_xltime();
	}
	unlock_task(stream_lock,"s_write");

	ret = (*tbl->write)(s,data,len);
	if ( ret >= 0 )
		calc_checksum(s,data,ret,1);

	lock_task(stream_lock);
	s->h.write_tid = 0;
	s->h.write_in_time = 0;
	unlock_task(stream_lock,"s_write(2)");

	s_delete_thread(s,&t);
	change_pri(0,pri);

	return ret;
}


SBUF_DATA * 
get_sbuf_marge_all(STREAM_BUF * sb)
{
SBUF_DATA * d;
SBUF_DATA * h,* t;
int len;
char * ptr;
	h = t = 0;
	len = 0;
	for ( ; ; ) {
		d = get_sbuf_head(sb,SEM_NULL);
		if ( d == 0 )
			break;
		len += d->len;
		d->next = 0;
		if ( h == 0 )
			h = t = d;
		else {
			t->next = d;
			t = d;
		}
	}
	if ( h == 0 )
		return 0;
	d = d_alloc(sizeof(SBUF_DATA)+len);
	d->len = len;
	ptr = (char*)(d+1);
	for ( ; h ; ) {
		t = h->next;
		memcpy(ptr,h+1,h->len);
		ptr += h->len;
		d_f_ree(h);
		h = t;
	}
	return d;
}


void
write_log(int ckp)
{
	log_printf(LOG_DEBUG,LOG_LAYER_GB,0,
	       "WRITE-BUFFER-ERROR");
}

int
_s_write(STREAM * s)
{
S_TABLE * tbl;
S_FILE_THREAD t;
int ret;
SBUF_DATA * d;
char * ptr;
int len,_ret;
int er;


	if ( s->h.tbl == 0 ) {
		return -1;
	}
	tbl = s->h.tbl;
	d = get_sbuf_marge_all(&s->h.write_buf);
	if ( d == 0 ) {
		return 0;
	}
	_s_insert_thread(s,&t);
	unlock_task(stream_lock,"s_write");

	ptr = (char*)(d+1);
	len = d->len;
	_ret = 0;
	er = 0;
	for ( ; len ; ) {
		ret = (*tbl->write)(s,ptr,len);
		if ( ret < 0 ) {
			er = -1;
			break;
		}
		len -= ret;
		ptr += ret;
		_ret += ret;
	}
	
	d_f_ree(d);

	lock_task(stream_lock);
	
	if ( er == -1 ) {
		free_sbuf(&s->h.write_buf,SEM_NULL);
		if ( _ret == 0 )
			_ret = -1;
	}

	_s_delete_thread(s,&t);

	return _ret;
}

void
s_write_task()
{
STREAM * target;
int ret;
int c;
int nos;
	lock_task(stream_lock);
	for ( ; ; ) {
		nos = 0;
		for ( target = stream_list ; target ; target = target->h.next , nos ++ );
		c = 0;
		if ( nos == 0 )
			goto wait;
	retry:
		for ( target = stream_list ; target ; target = target->h.next , c ++ ) {
			if ( c < s_write_pos )
				continue;
			if ( target->h.tbl == 0 )
				continue;
			if ( target->h.wb_flags & WBF_MASK )
				continue;
			if ( target->h.write_buf.head )
				goto ok;
		}
		if ( c < s_write_pos + nos ) {
			goto retry;
		}
	wait:
		if ( s_write_wait ) {
			unlock_task(stream_lock,"s_write_task");
			break;
		}
		s_write_wait ++;
		sleep_task((int)s_write,stream_lock);

		lock_task(stream_lock);
		s_write_wait --;
		continue;
	ok:
		s_write_pos = (c+1) % nos;
		target->h.wb_flags |= WBF_WRITING;
		ret = 	1;
		for ( ; ret > 0 ; ) {
			ret = _s_write(target);
		}
		if ( ret < 0 )
			target->h.wb_flags |= WBF_ERROR;
		target->h.wb_flags &= ~WBF_WRITING;
		wakeup_task((int)&target->h.write_buf);
	}
}


void
s_set_write_abort(STREAM * s,int type,int interval)
{
	lock_task(stream_lock);
	s->h.write_abort_type = type;
	s->h.write_abort_interval = interval;
	if ( s_write_abort_task_flag == 0 ) {
		s_write_abort_task_flag = 1;
		create_task((void(*)(TKEY))s_write_abort_task,0,PRI_WRITE_BUF);
	}
	unlock_task(stream_lock,"s_set_write_abort");
}

void
s_write_abort_task()
{
STREAM * target;
INTEGER64 tim;
int tar;
	for ( ; ; ) {
		lock_task(stream_lock);
		tar = 0;
		tim = get_xltime();
		for ( target = stream_list ; target ; target = target->h.next ) {
			if ( target->h.write_abort_type == 0 )
				continue;
			tar = 1;
			if ( target->h.write_in_time == 0 )
				continue;
			if ( tim - target->h.write_in_time < target->h.write_abort_interval )
				continue;
			s_write_abort_cnt ++;
			switch ( target->h.write_abort_type ) {
			case WAT_SIGNAL:
				throw_signal(target->h.write_tid,0);
				break;
			case WAT_CLOSE:
				throw_signal(target->h.write_tid,0);
				s_close_queue(target);
				break;
			default:
				er_panic("s_write_abort_task");
			}
		}
		if ( tar == 0 ) {
			s_write_abort_task_flag = 0;
			break;
		}
		unlock_task(stream_lock,"s_write_abort_task");
		sleep_sec(13);
	}
	unlock_task(stream_lock,"s_write_abort_task");
}

void
s_write_tick()
{
	lock_task(stream_lock);
	if ( s_write_wait == 0 )
		create_task((void(*)(TKEY))s_write_task,0,PRI_WRITE_BUF);
	unlock_task(stream_lock,"s_write_tick");
}
