/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_ALIGN_VIEW_H___
#define ___V_ALIGN_VIEW_H___

#include "v/VObject.h"


class VAlignView : public VObject
{
  public:
	enum { object_type = VO_GRPV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return MAX_CHILDREN_NO_LIMIT; }
	
	enum VAlignViewAttr {
		tab_page = 0x01
	};

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	// reorder child - order=0 -> first, order=1 -> second, ... order=-1 -> last
	virtual VExError	reorder_child(VObject *child, int order);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
		
  protected:
	virtual ~VAlignView();
	
	virtual void	destroy_do(VObject*);
	virtual VExError add_child_do(VObject*);
	virtual void	remove_child_do(VObject* child);
};

class VHAlignView : public VAlignView
{
  public:
	enum { object_type = VO_HGRV };
	virtual unsigned	get_type() const { return object_type; }
	
	static VHAlignView*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VHAlignView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VHAlignView*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);

  private:
	static VObject *internal_new(){
		return new VHAlignView();
	}
};

class VVAlignView : public VAlignView
{
  public:
	enum { object_type = VO_VGRV };
	virtual unsigned	get_type() const { return object_type; }
	
	static VVAlignView*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VVAlignView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err=0) {
		return static_cast<VVAlignView*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);

  private:
	static VObject *internal_new(){
		return new VVAlignView();
	}
};

#endif
