/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"
#include "win_flame.h"
#include "machine/msequence.h"

char gv_flame_dirty_flag = 0;
extern char gv_flame_initial_done;


void
call_gv_flame_event(GBVIEW_FLAME * gf,int type,void * w,void * arg)
{
XL_INTERPRETER * xli;
XL_SEXP * sym, * cmd, * ret;
int id;
char buf[20];

	xli = get_my_xli(); 

	if ( xli == 0 ) {
		xli = new_xl_interpreter();
		xli->a_type = XLA_SELF;
		setup_i(xli);
	}

	id = (int)arg;

	gc_push(0,0,"call_gv_flame_event");
	sym = n_get_symbol("gv-flame-event");
	sprintf(buf,"%d", id);
	set_attribute(sym,l_string(std_cm,"flame-id"),l_string(std_cm,buf));
	
	switch ( type ) {
	case ET_REDRAW:
		if ( gv_flame_dirty_flag )
			cmd = 0;
		else {
			gv_flame_dirty_flag = 1;
			cmd = List(sym,get_integer(type,0),0,-1);
 		}
		break;
	case ET_CLICK:
		cmd = List(sym,get_integer(type,0),
 				List(n_get_symbol("quote"),gbp2list(w,0),-1),
 				-1);
		break;
	case ET_INFO:
		cmd = List(sym,get_integer(type,0),
  				List(n_get_symbol("quote"),gvstatus2list(w),-1),
 				-1);
		break;
	case ET_INSERT:
	case ET_CHANGE_BASE:
	case ET_LOCK_BASE:
		cmd = List(sym,get_integer(type,0),0,-1);
		break;
	default:
		er_panic("interface_event_func(1)");
	}
	if ( cmd ) {
		ret = eval(gblisp_top_env0,cmd);
		if ( get_type(ret) == XLT_ERROR ) {
			fflush(stdout);
			s_printf(s_stdout,"EVENT ");
			print_sexp(s_stdout,cmd,0);
			s_printf(s_stdout," error response -> ");
			print_sexp(s_stdout,ret,0);
			s_printf(s_stdout,"\n");
		}
	}
	gc_pop(0,0);
}

void
event_loop()
{
	if ( ! gv_flame_initial_done )
		sleep_task((int)&gv_flame_initial_done,SEM_NULL);
	ms_loop();
}

void
init_gv_flame_event(XLISP_ENV * env)
{
}
