/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdio.h>
#include	"memory_routine.h"
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"resource.h"
#include	"utils.h"
#include	"xl.h"
#include	"task.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"rs_cache.h"
#include	"rcache.h"
#include	"save_global.h"
#include	"mx_format.h"
#include	"win_flame.h"

typedef struct res_matrix_t {
	Q_HEADER		h;
	XL_SEXP *		ret;
	RESOURCE *		r;
	MATRIX_TOKEN *		token;
	int			aboat_flag;
	int			loop_no;
} RES_MATRIX_T;

SYS_QUEUE res_matrix_before,res_matrix_after;
void
aboat_matrix_token(MATRIX_TOKEN * t);


XL_SEXP *
gbrm_gmxStatus(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);
void
insert_dirty(RESOURCE * r,GB_RECT * rct);
void
_exec_dirty(int data);
void
gc_res_matrix_func(RES_MATRIX_T*);
void
gc_res_matrix_get(RES_MATRIX_T*);
void
res_matrix_task_before(TKEY d);
void
res_matrix_task_after(TKEY d);
void
open_res_matrix(MATRIX_TOKEN * t);
void * get_res_matrix_work(RESOURCE * r);
void
res_matrix_close(MATRIX * m);
void res_matrix_new_token(MATRIX_TOKEN * t,int type);
void res_matrix_free_token(MATRIX_TOKEN * t ,int type);
void
res_matrix_trigger(int type,void * data);

XLISP_ENV * resource_matrix_env;
XLISP_ENV * resource_matrix_gmxEnv;
SEM res_matrix_lock;
extern SEM res_lock;

void
init_resource_matrix()
{
XLISP_ENV * gmxEnv;


	res_matrix_lock = new_lock(LL_RES_MATRIX);
	memset(&res_matrix_before,0,sizeof(SYS_QUEUE));
	res_matrix_before.flags = QF_FIFO;
	res_matrix_before.gc_func = gc_res_matrix_func;
	res_matrix_before.gc_get = gc_res_matrix_get;
	res_matrix_before.pri = PRI_FETCH;
	res_matrix_before.key_func = res_matrix_task_before;
	setup_queue(&res_matrix_before);

	memset(&res_matrix_after,0,sizeof(SYS_QUEUE));
	res_matrix_after.flags = QF_FIFO;
	res_matrix_after.gc_func = gc_res_matrix_func;
	res_matrix_after.gc_get = gc_res_matrix_get;
	res_matrix_after.pri = PRI_FETCH;
	res_matrix_after.key_func = res_matrix_task_after;
	setup_queue(&res_matrix_after);
	
	resource_matrix_env = new_env(gblisp_top_env0);
	resource_matrix_gmxEnv = gmxEnv = new_env(0);
	set_env(resource_matrix_env,l_string(std_cm,"gmxStatus"),
		get_func_prim(gbrm_gmxStatus,FO_NORMAL,gmxEnv,1,-1));
	init_gmx_format(gmxEnv);
}

void
gc_resource_matrix()
{
	gc_gblisp_env(resource_matrix_env);
	gc_gblisp_env(resource_matrix_gmxEnv);
}


void
gc_res_matrix_func(RES_MATRIX_T * t)
{
	gc_gb_sexp(t->ret);
}

void
gc_res_matrix_get(RES_MATRIX_T * t)
{
	lock_mem();
	gc_set_nl(t->ret,gc_gb_sexp);
	unlock_mem();
}

int
insert_resource_matrix(RESOURCE * r,int w_flag)
{
RES_MATRIX_T * t;


	lock_task(res_lock);
	if ( r->h.mtx_loading ) {
		unlock_task(res_lock,"insert_resource_matrix");
		return 0;
	}
	r->h.mtx_loading = 1;
	unlock_task(res_lock,"insert_resource_matrix");
	t = new_queue_node(sizeof(*t));
	t->ret = 0;
	t->r = r;
	t->token = 0;
	t->h.key = get_server_key(&r->h.target,0);
	return insert_queue(&res_matrix_before,t,w_flag);
}


int
insert_res_matrix_read_net(MATRIX_TOKEN * tk)
{
RESOURCE * r;
RES_MATRIX_T * t;

	r = tk->process_node->matrix->open_work;
	t = new_queue_node(sizeof(*t));
	t->loop_no = r->pr64.loop_no;
	t->ret = 0;
	t->r = 0;
	t->token = tk;
	t->h.key = get_server_key(&r->h.target,0);
	tk->work = (void*)t;
	tk->aboat_func = aboat_matrix_token;
	insert_queue(&res_matrix_before,t,1);
	return 1;
}

void
res_matrix_task_before(TKEY d)
{
int ses;
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
RES_MATRIX_T * t;
XL_SEXP * query;
XL_SEXP * sym;
L_CHAR * f;
RESOURCE * r;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);


	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {
		gc_push(0,0,"res_matrix_task_before");
		t = delete_queue(que,sq_key_cond,key,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}
		if ( t->r ) {
			if ( t->aboat_flag ) {
				d_f_ree(t);
				gc_pop(0,0);
				break;
			}
			sym = n_get_symbol("Get");
			set_attribute(sym,l_string(std_cm,"mode"),l_string(std_cm,"meta"));
			f = get_url_filepath(&t->r->h.target);
			query = List(sym,get_string(f),-1);
			d_f_ree(f);
			t->ret = remote_session(gblisp_top_env0,ses,
				&t->r->h.target,
				0,
				l_string(std_cm,"user"),
				l_string(std_cm,"Get"),
				List(query,-1),
				0,0,0,0);
		}
		else {
			if ( t->aboat_flag ) {
				t->token->work = 0;
				matrix_token_error(t->token);
				d_f_ree(t);
				gc_pop(0,0);
				continue;
			}
			r = t->token->process_node->matrix->open_work;
			sym = n_get_symbol("Get");
			set_attribute(sym,l_string(std_cm,"mode"),l_string(std_cm,"data"));
			f = get_url_filepath(&r->h.target);
			query = List(sym,get_string(f),
					List(n_get_symbol("quote"),
						get_sexp_from_dim_code(t->token->process_node->matrix,t->token->process_node->dim_code),
						-1),
					-1);
			d_f_ree(f);
			t->ret = remote_session(gblisp_top_env0,ses,
				&r->h.target,
				0,
				l_string(std_cm,"user"),
				l_string(std_cm,"Get"),
				List(query,-1),
				0,0,0,0);
		}
		insert_queue(&res_matrix_after,t,1);
		gc_pop(0,0);
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();

}


#define LOCK_CNT 5
MATRIX * debug_target_matrix;
int lock_cnt;

void
res_matrix_task_after(TKEY d)
{
int ses;
XL_INTERPRETER * xli;
L_CHAR * key;
SYS_QUEUE * que;
RES_MATRIX_T * t;
XL_SEXP * cmd;
XL_SEXP * sym;
CREATE_PARAM cp;
RS_BUF b;
L_CHAR * filename;
XL_SEXP * ret;
int i;
RESOURCE * r;

	que = (SYS_QUEUE *)GET_TKEY(d);
	key = touch_qkey(que);
	if ( key == 0 )
		return;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);


	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {
		gc_push(0,0,"res_matrix_task_after");
		t = delete_queue(que,sq_key_cond,key,0);
		if ( t == 0 ) {
			gc_pop(0,0);
			break;
		}
		if ( t->r ) {
			if ( t->aboat_flag ) {
				goto err2;
			}
			if ( get_type(t->ret) == XLT_ERROR ) {
				ss_printf("ERROR=");
				print_sexp(s_stdout,t->ret,0);
				ss_printf("\n");
				insert_lw_service_code_flag_set(t->r,t->ret);
				goto err2;
			}
			cmd = get_el_by_symbol(t->ret,l_string(std_cm,"gmxStatus"),0);
			if ( get_type(cmd) != XLT_PAIR ) {
				goto err2;
			}
			// FILE Name on the cache

			if ( t->r->h.cache_file_id == 0 ) {
				memset(&b,0,sizeof(b));
				b.r = t->r;
				set_rs_resource_cache(&b);
			}

			// FILE Lock Operation

			if ( t->r->h.cache_file_id == 0 )
				goto err2;

			filename = get_filepath_from_file_id(t->r->h.cache_file_id,".mtx");

			sym = car(cmd);
			set_attribute(sym,l_string(std_cm,"neturl"),
				get_url_str2(&t->r->h.target));
			set_attribute(sym,l_string(std_cm,"filename"),
				filename);
			d_f_ree(filename);

			memset(&cp,0,sizeof(cp));

			cp.p.write_file = matrix_standard_write_file;
			cp.p.read_file = matrix_standard_read_file;
			cp.p.read_net = insert_res_matrix_read_net;
			cp.p.close_file = res_matrix_close;
			cp.p.new_token = res_matrix_new_token;
			cp.p.free_token = res_matrix_free_token;
			cp.p.trigger = res_matrix_trigger;

			ret = gb_gmxCreate_matrix(&cp,resource_matrix_env,cmd,
				resource_matrix_gmxEnv,sym->symbol.field);
			if ( get_type(ret) == XLT_ERROR ) {
				print_sexp(s_stdout,ret,0);
				ss_printf("\n");
			}
			if ( cp.m ) {
				cp.m->open_work = (void*)t->r;
				t->r->h.mtx = cp.m;
				t->r->h.visu_channel = -1;
				for ( i = 0 ; i < cp.m->p.channel_nos ; i ++  ) {
					if ( cp.m->channel_info[i].data_type == 0 )
						continue;
					if ( cp.m->channel_info[i].flags & MF_VISU ) {
						t->r->h.visu_channel = i;
						break;
					}
				}
				res_matrix_trigger(TRT_MATRIX_STANBY,(void*)cp.m);
			}
		err2:
			;
			t->r->h.mtx_loading = 0;
			d_f_ree(t);
			lock_task(res_lock);
			unlock_task(res_lock,"matrix");
		}
		else {
			if ( t->aboat_flag )
				goto err;
			if ( get_type(t->ret) == XLT_ERROR ) {
				r = (RESOURCE*)t->token->process_node->matrix->open_work;
				insert_lw_service_code_flag_set(r,t->ret);
				goto err;
			}

			if ( decode_matrix_node(t->token->process_node,t->ret) < 0 )
				goto err;

			debug_target_matrix = t->token->process_node->matrix;
			lock_task(res_matrix_lock);
			t->token->work = 0;
			t->token->aboat_func = 0;
			insert_matrix_access(t->token,matrix_exec_cal);
			d_f_ree(t);
			unlock_task(res_matrix_lock,"res_matrix");
			goto finish1;
		err:
			lock_task(res_matrix_lock);
			t->token->work = 0;
			t->token->aboat_func = 0;
			matrix_token_error(t->token);
			d_f_ree(t);
			unlock_task(res_matrix_lock,"res_matrix");
		finish1:
			;
		}
		gc_pop(0,0);
/*
if ( lock_cnt > LOCK_CNT ) {
ss_printf("LOCK\n");
for( ; ; )
sleep_sec(1);
}
else lock_cnt ++;
*/
	}

	release_qkey(que,key);
	d_f_ree(key);

	close_session(ses);
	close_self_interpreter();

}

void * get_res_matrix_work(RESOURCE * r)
{
	return (void*)r;
}

void
res_matrix_close(MATRIX * m)
{
	close_matrix_file(m);
}


void res_matrix_new_token(MATRIX_TOKEN * t,int type)
{
	if ( type != MPT_NEW_TOKEN_NODE )
		return;
	t->work = 0;
}

void res_matrix_free_token(MATRIX_TOKEN * t ,int type)
{
	if ( type != MPT_NEW_TOKEN_NODE )
		return;
}


void
res_matrix_trigger(int type,void * data)
{
I_RECT ir;
GB_RECT rct;
REAL1 dpm;
RESOURCE * r;
//TREE_NODE * tn;
//TREE_CACHE * tc;

MATRIX * m;
MATRIX_NODE * n;
MATRIX_TOKEN * n2;

	switch ( type ) {
	case TRT_MATRIX_STANBY:
		m = data;
		r = m->open_work;
		dpm = r->pr64.dpm;
		rct.tl.x = rct.tl.y = 0;
		rct.br.x = m->pixel_size[0] / dpm;
		rct.br.y = m->pixel_size[1] / dpm;
		insert_dirty(r,&rct);
		_exec_dirty(1);
		return;
	case TRT_FINISH:
		_exec_dirty(1);
		return;
	case TRT_TOKEN:
		n2 = data;

	//		tn = n2->tn;
		m = (n =n2->process_node)->matrix;
		r = m->open_work;

		ir.tl.x = n->dim_code[1] & 
			(- (1<<(n->dim_code[0]*m->dim_divide[0]
			+ m->block_size[0])));
		ir.tl.y = n->dim_code[2] &
			(- (1<<(n->dim_code[0]*m->dim_divide[1]
			+ m->block_size[1])));
		ir.br.x = ir.tl.x +
				(1<<(n->dim_code[0] * m->dim_divide[0] +
					m->block_size[0]));
		if ( ir.br.x > m->pixel_size[0] )
			ir.br.x = m->pixel_size[0];
		ir.br.y = ir.tl.y +
				(1<<(n->dim_code[0] * m->dim_divide[1] +
					m->block_size[1]));
		if ( ir.br.y > m->pixel_size[1] )
			ir.br.y = m->pixel_size[1];
		dpm = r->pr64.dpm;
		rct.tl.x = ir.tl.x / dpm;
		rct.tl.y = ir.tl.y / dpm;
		rct.br.x = ir.br.x / dpm;
		rct.br.y = ir.br.y / dpm;
	/*
		tc = n2->tc;
		if ( n2->req_level <= tn->level ||
				tc->rt_level - n2->req_level 
				> 2*(tc->rt_level - tn->level) )
	*/
	/*
		if ( n->req_level <= n->dim_code[0] ||
				m->total_levels - n->req_level
				> 2*(m->total_levels - n->dim_code[0]) ) {

	*/
	/*
			wf_insert_dirty_rect(r,
				&rct,WFF_LUSTER_DIRTY,120,10);
	*/

			insert_dirty(r,&rct);

	//	}
		break;
	default:
		er_panic("omx_trigger");
	}

}


/*
void
open_res_matrix(MATRIX_TOKEN * t)
{
int err;
MATRIX * m;
MATRIX_PARAM p;
int er;
MATRIX_CHANNEL_INFO inf;
RS_BUF b;
int dd;
RESOURCE * r;

int err_code;

	err_code = 1;

	m = t->wait_matrix;
	r = m->open_work;

	// FILE Name on the cache

	if ( r->h.cache_file_id == 0 ) {
		memset(&b,0,sizeof(b));
		b.r = r;
		set_rs_resource_cache(&b);
	}

	// FILE Lock Operation

	if ( r->h.cache_file_id ) {

		m->filename = get_filepath_from_file_id(r->h.cache_file_id,".mtx");
		err = load_matrix_header(m,O_RDWR,0644);


ss_printf("old_matrix err %i\n",err);
		if ( err == 0 ) {
			memset(&p,0,sizeof(p));
			p.write_file = matrix_standard_write_file;
			p.read_file = matrix_standard_read_file;
			p.read_net = insert_res_matrix_read_net;
			p.close_file = res_matrix_close;
			p.new_token = res_matrix_new_token;
			p.free_token = res_matrix_free_token;
			p.trigger = res_matrix_trigger;

	err_code = 2;
			er = set_matrix_param(m,&p);
			if ( er < 0 )
				goto error;
			goto exist_file;
		}
	}


	memset(&p,0,sizeof(p));
	p.channel_nos = CH_MAX;
	p.total_levels = r->pr64.max_level;
	p.modify_time = r->h.modify;
	p.flags = MPF_CACHE_FILE;
	p.dim = 2;
	p.pri_area[MI_FETCH_1_TP] = PR_UP + 0x2000000;
	p.pri_area[MI_FETCH_1_MD] = PR_UP + 0x2000000;
	p.pri_area[MI_FETCH_1_BT] = PR_UP + 0x2000000;
	p.pri_area[MI_FETCH_2_TP] = PR_UP + 0x2000000;
	p.pri_area[MI_FETCH_2_MD] = PR_UP + 0x2000000;
	p.pri_area[MI_FETCH_2_BT] = PR_UP + 0x2000000;
	p.pri_area[MI_VISU_1_TP] = PR_UP + 0x2000000;
	p.pri_area[MI_VISU_1_MD] = PR_UP + 0x2000000;
	p.pri_area[MI_VISU_1_BT] = PR_UP + 0x2000000;
	p.pri_area[MI_SAVE_TP] = PR_STRT + 0x2000000;
	p.pri_area[MI_SAVE_MD] = PR_STRT + 0x2000000;
	p.pri_area[MI_SAVE_BT] = PR_STRT + 0x2000000;


	p.write_file = matrix_standard_write_file;
	p.read_file = matrix_standard_read_file;
	p.read_net = insert_res_matrix_read_net;
	p.close_file = res_matrix_close;
	p.new_token = res_matrix_new_token;
	p.free_token = res_matrix_free_token;
	p.trigger = res_matrix_trigger;

	er = set_matrix_param(m,&p);
	err_code = 3;
	if ( er < 0 )
		goto error;
	er = set_matrix_dim_divide(m,0,1);		// divide 2^1
	err_code = 4;
	if ( er < 0 )
		goto error;
	er = set_matrix_block_size(m,0,8);		// blocksize = 2^8
	err_code = 5;
	if ( er < 0 )
		goto error;
	er = set_matrix_dim_divide(m,1,1);
	err_code = 6;
	if ( er < 0 )
		goto error;
	er = set_matrix_block_size(m,1,8);
	err_code = 7;
	if ( er < 0 )
		goto error;


	er = set_matrix_pixel_size(m,0,r->pr64.width[0]);
	err_code = 8;
	if ( er < 0 )
		goto error;

	er = set_matrix_pixel_size(m,1,r->pr64.height[0]);
	err_code = 9;
	if ( er < 0 )
		goto error;
	
	inf.data_type = &mx_type_sexp;
	inf.flags = 0;
	inf.default_data = 0;
	er = set_matrix_channel_info(m,CH_NET,&inf);
	err_code = 10;
	if ( er < 0 )
		goto error;

	inf.data_type = &mx_type_uint32_v;
	inf.flags = MF_FILE|MF_VISU;
	dd = C_TRANSPARENT;
	inf.default_data = &dd;
	er = set_matrix_channel_info(m,CH_VISU,&inf);
	err_code = 11;
	if ( er < 0 )
		goto error;

exist_file:

	switch ( r->pr64.type ) {
	case 'P':
	case 'G':
	case 'B':

		set_matrix_cal(m,MI_VISU_1_BT,
			sexp_commands(
				std_cm,
		"<mxFinish",
		"	normal-jump-status=\"MS_OK\"",
		"	err-jump-status=\"MS_PROCESS_ERR_1\"/>",
		"(mxSet 1 ([mxUncompressOldFormat format=\"R64\"] (mxCH 2)))",
			0));
		set_matrix_cal_equ(m,MI_VISU_1_MD,MI_VISU_1_BT);
		set_matrix_cal(m,MI_VISU_1_TP,
			sexp_commands(
				std_cm,
			"(mxSet 1 ([mxUncompressOldFormat format=\"R64\"] (mxCH 2)))",
			0));
		break;
	case '0':
	case '1':
	case '2':

		set_matrix_cal(m,MI_VISU_1_BT,
			sexp_commands(
				std_cm,
		"<mxFinish",
		"	normal-jump-status=\"MS_OK\"",
		"	err-jump-status=\"MS_PROCESS_ERR_1\"/>",
		"(mxSet 1 ([mxUncompressOldFormat format=\"CR\"] ([mxCH type=\"parent\"] 1) (mxCH 2)))",
			0));
		set_matrix_cal_equ(m,MI_VISU_1_MD,MI_VISU_1_BT);
		set_matrix_cal(m,MI_VISU_1_TP,
			sexp_commands(
				std_cm,
			"<mxFinish",
			"	normal-jump-status=\"MS_OK\"",
			"	err-jump-status=\"MS_PROCESS_ERR_1\"/>",
			"(mxSet 1 ([mxUncompressOldFormat format=\"CR\"] (mxCH 2)))",
			0));
		break;
	default:
		er_panic("invalid type");
	}

	if ( r->h.cache_file_id ) {

		set_matrix_cal(m,MI_SAVE_TP,
			sexp_commands(
				std_cm,
				"<mxSave/>",
			0));
		set_matrix_cal_equ(m,MI_SAVE_MD,MI_SAVE_TP);
		set_matrix_cal_equ(m,MI_SAVE_BT,MI_SAVE_TP);
		
		set_matrix_cal(m,MI_FETCH_1_TP,
			sexp_commands(
				std_cm,
				"<mxFinish",
				"	err-jump=\"MI_FETCH_2\"",
				"	normal-jump-status=\"MS_OK\"/>",
				"<mxLoad target=\"file\"/>",
			0));
		set_matrix_cal_equ(m,MI_FETCH_1_MD,MI_FETCH_1_TP);
		set_matrix_cal_equ(m,MI_FETCH_1_BT,MI_FETCH_1_TP);

		set_matrix_cal(m,MI_FETCH_2_TP,
			sexp_commands(
				std_cm,
				"<mxFinish",
				"	normal-jump=\"MI_VISU_1\"",
				"	err-jump-status=\"MS_LOADING_ERR_1\"/>",
				"<mxLoad target=\"net\"/>",
			0));
		set_matrix_cal_equ(m,MI_FETCH_2_MD,MI_FETCH_2_TP);
		set_matrix_cal_equ(m,MI_FETCH_2_BT,MI_FETCH_2_TP);
		
		if ( err == ME_DESTROY_FILE || err == ME_CANNOT_OPEN_FILE )
			save_matrix_header(m);

	}
	else {
		set_matrix_cal(m,MI_SAVE_TP,
			sexp_commands(
				std_cm,
				"<mxSave option=\"clear\"/>",
			0));
		set_matrix_cal_equ(m,MI_SAVE_MD,MI_SAVE_TP);
		set_matrix_cal_equ(m,MI_SAVE_BT,MI_SAVE_TP);
		
		set_matrix_cal(m,MI_FETCH_1_TP,
			sexp_commands(
				std_cm,
				"<mxFinish",
				"	normal-jump=\"MI_VISU_1\"",
				"	err-jump-status=\"MS_LOADING_ERR_1\"/>",
				"<mxLoad target=\"net\"/>",
			0));
		set_matrix_cal_equ(m,MI_FETCH_1_MD,MI_FETCH_1_TP);
		set_matrix_cal_equ(m,MI_FETCH_1_BT,MI_FETCH_1_TP);
		
	}

	set_matrix_mode(m,MM_STANBY);
	;
	d_f_ree(t);
	return;
error:
	er_panic("ERROR");
}
*/

XL_SEXP *
gbrm_gmxStatus(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * ret;
CREATE_PARAM cp;

	memset(&cp,0,sizeof(cp));

	cp.p.write_file = matrix_standard_write_file;
	cp.p.read_file = matrix_standard_read_file;
	cp.p.read_net = insert_res_matrix_read_net;
	cp.p.close_file = res_matrix_close;
	cp.p.new_token = res_matrix_new_token;
	cp.p.free_token = res_matrix_free_token;
	cp.p.trigger = res_matrix_trigger;

	ret = gb_gmxCreate_matrix(&cp,env,s,a,sf);
	if ( ret == 0 )
		goto open_err;

	if ( get_type(ret) == XLT_ERROR )
		return ret;

	return 0;
open_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxCreate"),
		0);
}

void
aboat_matrix_token(MATRIX_TOKEN * t)
{
RES_MATRIX_T * tk;

	lock_task(res_matrix_lock);
	tk = (RES_MATRIX_T*)t->work;
	if ( tk == 0 )
		goto end;
	tk->aboat_flag = 1;
	aboat_session(tk->ret);
end:
	unlock_task(res_matrix_lock,"aboat");
}


