/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VTableView.h"
#include "machine/v_object.h"


VExError
VTableView::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	table_set *set = (table_set *)arg;
	rows = set->rows > 0 ? set->rows : 1;
	cols = set->cols > 0 ? set->cols : 1;
	info = v_serialized_exec_func<GtkWidget*, guint, guint, gboolean>(
		gtk_table_new, rows, cols, false);
	v_serialized_exec_sub(g_object_ref, info);

	for ( int key = 0 ; key < v_table_child_hash_size ; key++ )
		child_hash[key] = 0;
	
	return return_create_do(this,nmp,&sts,s,flags);
}

void
VTableView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
	
	for ( int key = 0 ; key < v_table_child_hash_size ; key++ )
		if ( child_hash[key] )
			er_panic("VTableView::destroy_do");
}

VTableView::~VTableView()
{
}

VExError
VTableView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VTableView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_HOMOGEN ) {
		v_serialized_exec_sub(gtk_table_set_homogeneous,
			GTK_TABLE(info), s->homogeneous);
		err.subcode1 &= ~VSF_HOMOGEN;
	}
	if ( flags & VSF_SPACING ) {
		v_serialized_exec_sub(gtk_table_set_row_spacings, GTK_TABLE(info), (unsigned)s->spacing.h);
		v_serialized_exec_sub(gtk_table_set_col_spacings, GTK_TABLE(info), (unsigned)s->spacing.w);
		err.subcode1 &= ~VSF_SPACING;
	}
	
	V_OP_END
		
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

struct attach_child_arg {
	GtkWidget *table, *child;
	unsigned row, col, row_span, col_span;
	int xopt, yopt;
	unsigned xpad, ypad;
};

void
gtk_table_attach_glue(attach_child_arg *arg, bool need_remove)
{
	gtk_widget_ref(arg->child);
	if ( need_remove )
		gtk_container_remove(GTK_CONTAINER(arg->table), arg->child);
	gtk_table_attach(GTK_TABLE(arg->table), arg->child,
		arg->col, arg->col+arg->col_span,
		arg->row, arg->row+arg->row_span,
		(GtkAttachOptions)arg->xopt, (GtkAttachOptions)arg->yopt, arg->xpad, arg->ypad);
	gtk_widget_unref(arg->child);
}

int
valign_2_attach_options(char align)
{
	if ( align == VALIGN_EXPAND )
		return GTK_EXPAND;
	if ( align == VALIGN_FILL )
		return GTK_EXPAND|GTK_FILL;
	return GTK_SHRINK;
}

void
v_table_view_attach_child(
	VObject *nmc,
	VTableView::table_child_set *c,
	VInfo *info,
	bool need_remove)
{
	VObjectStatus s;
	nmc->get_status(&s, VSF_ALIGN | VSF_PADDING);
	attach_child_arg arg = {
			info, nmc->get_info_this(),
			c->row, c->col, c->row_span, c->col_span,
			valign_2_attach_options(s.alignh),
			valign_2_attach_options(s.alignv),
			s.padding.w, s.padding.h};
	v_serialized_exec_sub(gtk_table_attach_glue, &arg, need_remove);
}

VExError
VTableView::add_child_do(VObject* child)
{
	table_child_set *c;
	c = add_child_hash(child, 0, 0, rows, cols);	// assume attached all over the table
	v_table_view_attach_child(child, c, info, false);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VTableView::remove_child_do(VObject* child)
{
	remove_child_hash(child);
	v_serialized_exec_sub(gtk_container_remove, GTK_CONTAINER(info),
			child->get_info_this());
}

VExError
VTableView::resize_table(short rows, short cols)
{
	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	if ( rows <= 0 || cols <= 0 )
		err.code = V_ER_PARAM;
	else {
		this->rows = rows;
		this->cols = cols;
		v_serialized_exec_sub(gtk_table_resize, GTK_TABLE(info), (guint)rows, (guint)cols);
	}
	return err;
}


VExError
VTableView::attach_child(VObject* child, short row, short col, short row_span, short col_span)
{
	VObject * nmc;
	table_child_set *c;
	
	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	V_OP_START_EX
	
	if ( row < 0 || col < 0 || row_span <= 0 || col_span <= 0 ||
			row + row_span > rows || col + col_span > cols ) {
		err.code = V_ER_PARAM;
		goto end;
	}

	nmc = child->get_nmc(0);
	if ( nmc == 0 ) {
		err.code = V_ER_NOT_READY;
		goto end;
	}
	
	// check child is in the children list
	if ( search_child_hash(nmc) == 0 ) {
		err.code = V_ER_NOT_FOUND;
		goto end;
	}
	
	c = add_child_hash(nmc, row, col, row_span, col_span);
	
	lock(nmc,__FILE__,__LINE__);
	if ( get_destroy_time(nmc) != V_OBJECT_ALIVE ) {
		unlock(nmc);
		err.code = V_ER_DESTROYED;
		goto end;
	}
	
	v_table_view_attach_child(nmc, c, info, true);
	
	unlock(nmc);
  end:
	V_OP_END
	return err;
}

bool
VTableView::get_child_place(VObject *child,
	short *row, short *col, short *row_span, short *col_span)
{
	table_child_set *c = search_child_hash(child);
	if ( c == 0 )
		return false;
	if ( row )
		*row = c->row;
	if ( col )
		*col = c->col;
	if ( row )
		*row_span = c->row_span;
	if ( col )
		*col_span = c->col_span;
	return true;
}

void
VTableView::child_status_changed(VObject *child, VInfo* cinfo)
{
}

void
VTableView::redraw(VRect *rect) const
{
	// do nothing
}

VTableView::table_child_set *
VTableView::add_child_hash(VObject *child,
	short row, int short col, short row_span, short col_span)
{
	table_child_set *c;
	unsigned int key = hash_key(child);
	
	for ( c = child_hash[key] ; c ; c = c->next )
		if ( c->child == child )
			break;
	if ( c == 0 ) {
		c = new table_child_set;
		c->child = child;
		c->row = c->col = 0;
		c->row_span = c->col_span = 1;
		c->next = child_hash[key];
		child_hash[key] = c;
	}
	if ( row >= 0 && col >= 0 ) {
		c->row = row;
		c->col = col;
		c->row_span = row_span;
		c->col_span = col_span;
	}
	return c;
}

void
VTableView::remove_child_hash(VObject *child)
{
	table_child_set *c, *p = 0;
	unsigned int key = hash_key(child);
	for ( c = child_hash[key] ; c ; p = c, c = c->next )
		if ( c->child == child )
			break;
	if ( c ) {
		if ( p )
			p->next = c->next;
		else
			child_hash[key] = c->next;
		delete c;
	}
}

VTableView::table_child_set *
VTableView::search_child_hash(VObject *child)
{
	table_child_set *c;
	unsigned int key = hash_key(child);
	
	for ( c = child_hash[key] ; c ; c = c->next )
		if ( c->child == child )
			return c;
	return 0;
}
