/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VDisplay.h"
#include "v/VWindow.h"
#include "machine/v_object.h"

extern "C" void er_panic(char*);

VDisplay* VDisplay::main_display = 0;

VDisplay*
VDisplay::create()
{
	// VDisplay does not have parent
	VDisplay* ret = new VDisplay;
	ret->create_do(0,0,0,0);
	return ret;
}

VExError
VDisplay::create_do(const VObjectStatus * s, int flags, 
		VObject * nmp,void * arg)
{
	sts.parent = 0;
	if ( main_display )
		er_panic("multiple display construction");
	main_display = this;
	set_status(&v_default_sts, VSF_ALL_FLAGS);
printf("new disp [%d]\n", (int)sizeof(sts));

	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VDisplay::destroy_do(VObject * nmp)
{
	main_display = 0;
}

VDisplay::~VDisplay()
{
}


VError
VDisplay::accept_child_ex(long type, VObject *obj) const
{
	if ( type != VWindow::object_type )
		return V_ER_PARAM;
	return V_ER_NO_ERR;
}
