/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"mx_blk_h_layering.h"
#include	"change_endian.h"
#include	"xlerror.h"

typedef struct hl_click {
	struct hl_click *	next;
	double			reso;
	INTEGER64 *		ix;
	INTEGER64		show;
	INTEGER64		hide;
} HL_CLICK;


typedef struct hl_id_list {
	struct hl_id_list *	next;
	INTEGER64		id;
	HL_CLICK *		clk;
} HL_ID_LIST;

typedef struct hl_struct_block {
	MX_STRUCT_BLOCK			h;
	HL_ID_LIST *			id_list;
} HL_STRUCT_BLOCK;




MX_STRUCT_BLOCK * hl_new_sb(MX_SB_NEW*,void*);
MX_STRUCT_BLOCK * hl_copy_sb(MX_STRUCT_BLOCK*);
int  hl_block2struct(MX_STRUCT_BLOCK*,MATRIX_ALLOC_BLOCK_PARAM * b);
MATRIX_ALLOC_BLOCK_PARAM * hl_struct2block(MX_STRUCT_BLOCK * blk);
void hl_free_sb(MX_STRUCT_BLOCK * blk);
int hl_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param);
MX_STRUCT_BLOCK * hl_copy_sb(MX_STRUCT_BLOCK * );

MX_STRUCT_BLOCK_TBL blk_h_layering_tbl = {
	hl_new_sb,
	hl_free_sb,
	hl_copy_sb,
	hl_block2struct,
	hl_struct2block,
	hl_operation
};

MX_STRUCT_BLOCK * hl_new_sb(MX_SB_NEW* n,void* param)
{
HL_STRUCT_BLOCK * ret;
MX_SB_NEW nn;
	nn = *n;
	if ( nn.m ){
		if ( nn.n ) {
			if ( nn.n->matrix != nn.m )
				return 0;
		}
	}
	else {
		if ( nn.n ) {
			nn.m = nn.n->matrix;
		}
	}
	ret = d_alloc(sizeof(*ret));
	ret->h.n = nn;
	ret->id_list = 0;
	return (MX_STRUCT_BLOCK *)ret;
}


int
hl_insert_point(HL_STRUCT_BLOCK * b,INTEGER64 id,INTEGER64 * ix,double reso,INTEGER64 show,INTEGER64 hide,int f)
{
MATRIX * m;
HL_ID_LIST * idlist;
HL_CLICK * c;
double r,rate;
int i;
int ret;
	ret = 0;
	if ( reso == 0 )
		return -1;
	m = b->h.n.m;
	for ( idlist = b->id_list ; idlist ; idlist = idlist->next )
		if ( idlist->id == id )
			goto next;
	idlist = d_alloc(sizeof(*idlist));
	idlist->id = id;
	idlist->clk = 0;
	idlist->next = b->id_list;
	b->id_list = idlist;
next:
	rate = 1 + 0.6/(1<<m->block_size[0]);
	for ( c = idlist->clk ; c ; c = c->next ) {
		for ( i = 0 ; i < m->p.dim ; i ++ ) {
			if ( c->ix[i] != ix[i] )
				goto cont;
		}
		r = c->reso/reso;
		if ( r >= rate )
			continue;
		if ( r <= 1/rate )
			continue;
		goto next2;
	cont:
		;
	}
	c = d_alloc(sizeof(*c));
	c->ix = d_alloc(sizeof(INTEGER64)*m->p.dim);
	memcpy(c->ix,ix,sizeof(INTEGER64)*m->p.dim);
	c->reso = reso;
	ret = 1;
next2:
	if ( f ) {
		if ( c->show != show || c->hide != hide )
			ret = 1;
		c->show = show;
		c->hide = hide;
	}
	else {
		if ( show )
			c->show ++;
		if ( hide )
			c->hide ++;
		ret = 1;
	}
	return ret;
}


MX_STRUCT_BLOCK * hl_copy_sb(MX_STRUCT_BLOCK* b)
{
HL_STRUCT_BLOCK * ret,* _b;
HL_ID_LIST * idlist;
HL_CLICK * c;

	ret = (HL_STRUCT_BLOCK*)hl_new_sb(&b->n,0);
	_b = (HL_STRUCT_BLOCK*)b;
	idlist = ret->id_list;
	for ( ; idlist ; idlist = idlist->next ) {
		for ( c = idlist->clk ; c ; c = c->next )
			hl_insert_point(_b,idlist->id,c->ix,c->reso,c->show,c->hide,1);
	}
	return (MX_STRUCT_BLOCK*)ret;
}

void hl_free_sb(MX_STRUCT_BLOCK * blk)
{
HL_STRUCT_BLOCK * _b;
HL_CLICK * c;
HL_ID_LIST * id;
	_b = (HL_STRUCT_BLOCK*)blk;
	for ( ; _b->id_list ; ) {
		id = _b->id_list;
		_b->id_list = id->next;
		for ( ; id->clk ; ) {
			c = id->clk;
			id->clk = c->next;
			d_f_ree(c->ix);
			d_f_ree(c);
		}
		d_f_ree(id);
	}
	d_f_ree(_b);
}

HL_ID_LIST*
hl_search(HL_STRUCT_BLOCK * b,INTEGER64 id)
{
HL_ID_LIST * idlist;
	for ( idlist = b->id_list ; idlist ; idlist = idlist->next )
		if ( idlist->id == id )
			return idlist;
	return 0;
}

int
hl_calc(HL_STRUCT_BLOCK * b,HL_OP * op)
{
HL_ID_LIST * id;
HL_CLICK * c;
INTEGER64 * offset;
int dim;
double d,d1;
MATRIX * m;
MATRIX_NODE * n;
int i;
	id = hl_search(b,op->calc.id);
	if ( id == 0 )
		return -1;
	op->calc.show = 0;
	op->calc.hide = 0;
	n = b->h.n.n;
	offset = &b->h.n.n->dim_code[1];
	m = b->h.n.m;
	dim = m->p.dim;
	for ( c = id->clk ; c ; c = c->next ) {
		d1 = c->reso - op->calc.reso;
		d = d1*d1;
		for ( i = 0 ; i < dim ; i ++ ) {
			d1 = ((c->ix[i]<<(n->dim_code[0]*m->dim_divide[i])) + offset[i] - op->calc.ix[i]);
			d += d1*d1;
		}
		if ( c->show ) {
			op->calc.show += c->show/(sqrt(d) + HL_WEIGHT_GRUE);
		}
		if ( c->hide ) {
			op->calc.hide += c->hide/(sqrt(d) + HL_WEIGHT_GRUE);
		}
	}
	return 0;
}

INTEGER64 *
calc_ix(MATRIX_NODE * n,INTEGER64 * ix)
{
INTEGER64 * ret;
int i;
MATRIX * m;
	m = n->matrix;
	ret = d_alloc(sizeof(INTEGER64)*m->p.dim);
	for ( i = 0 ; i < m->p.dim ; i ++ ) {
		ret[i] = (ix[i] - n->dim_code[i+1])
			>> (m->dim_divide[i]*n->dim_code[0]);
	}
	return ret;
}


int hl_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param)
{
HL_OP *op;
HL_STRUCT_BLOCK * _b;
int ret;
INTEGER64 * ix;
	_b = (HL_STRUCT_BLOCK*)blk;
	op = (HL_OP*)param;
	switch ( cmd ) {
	case SBOP_INSERT:
		ix = calc_ix(blk->n.n,op->insert.ix);
		ret = hl_insert_point(_b,op->insert.id,ix,
				op->insert.reso,op->insert.show,op->insert.hide,0);
		d_f_ree(ix);
		if ( ret == 1 )
			set_dirty_file_sb(blk);
		if ( ret < 0 )
			return ret;
		return 0;
	case SBOP_CALC:
		return hl_calc(_b,op);
	default:
		return -1;
	}
}


int
hl_b2s_click(HL_STRUCT_BLOCK * b,INTEGER64 id,unsigned char ** ptr,int * size)
{
double reso;
INTEGER64 * ix;
INTEGER64 show,hide;
int i;
unsigned char * p;
	memcpy(&reso,*ptr,sizeof(double));
	*ptr += sizeof(double);
	*size -= sizeof(double);
	change_endian(reso);

	ix = d_alloc(sizeof(INTEGER64)*b->h.n.m->p.dim);
	for ( i = 0 ; i < b->h.n.m->p.dim ; i ++ ) {
		p = get_uncompressed_code64(&ix[i],*ptr);
		*size += p - *ptr;
		*ptr = p;
	}
	
	p = get_uncompressed_code64(&show,*ptr);
	*size += p - *ptr;
	*ptr = p;
	p = get_uncompressed_code64(&hide,*ptr);
	*size += p - *ptr;
	*ptr = p;

	hl_insert_point(b,id,ix,reso,show,hide,1);
	
	d_f_ree(ix);
	return 0;
}

int
hl_b2s_id_list(HL_STRUCT_BLOCK * b,unsigned char ** ptr,int * size)
{
INTEGER64 id;
INTEGER64 cnt;
unsigned char * p;
	p = get_uncompressed_code64(&id,*ptr);
	*size -= p - *ptr;
	*ptr = p;
	if ( *size <= 0 )
		return -1;
	p = get_uncompressed_code64(&cnt,*ptr);
	*size -= p - *ptr;
	*ptr = p;
	if ( *size <= 0 )
		return -1;

	for ( ; *size > 0 || cnt > 0 ; cnt -- ) {
		if ( hl_b2s_click(b,id,ptr,size) < 0 )
			return -1;
	}
	return 0;
}

int  hl_block2struct(MX_STRUCT_BLOCK* blk,MATRIX_ALLOC_BLOCK_PARAM * b)
{
unsigned char * ptr;
int size;
	ptr = b->block;
	size = b->size;
	for ( ; size > 0 ; ) {
		if ( hl_b2s_id_list((HL_STRUCT_BLOCK*)blk,&ptr,&size) < 0 )
			return -1;
	}
	return 0;
}

void
hl_s2b_click(HL_STRUCT_BLOCK * b,HL_CLICK * c,RECORD_LIST64 * rl)
{
double reso;
int i;
unsigned char * buf, * ptr;
	reso = c->reso;
	change_endian(reso);
	set_recordlist_chain64(rl,&reso,sizeof(reso),0);
	
	for ( i = 0 ; i < b->h.n.m->p.dim ; i ++ ) {
		buf = d_alloc(sizeof(INTEGER64)*2 + 1);
		ptr = get_compressed_code64(buf,c->ix[i]);
		set_recordlist_chain64(rl,buf,ptr-buf,1);
	}
	buf = d_alloc(sizeof(INTEGER64)*2 + 1);
	ptr = get_compressed_code64(buf,c->show);
	set_recordlist_chain64(rl,buf,ptr-buf,1);
	buf = d_alloc(sizeof(INTEGER64)*2 + 1);
	ptr = get_compressed_code64(buf,c->hide);
	set_recordlist_chain64(rl,buf,ptr-buf,1);
}

void
hl_s2b_id_list(HL_STRUCT_BLOCK * b,HL_ID_LIST * id,RECORD_LIST64 * rl)
{
INTEGER64 len;
HL_CLICK * c;
unsigned char * buf, * ptr;
	len = 0;
	for ( c = id->clk ; c ; c = c->next , len ++ );
	buf = d_alloc(sizeof(INTEGER64)*2 + 1);
	ptr = get_compressed_code64(buf,id->id);
	set_recordlist_chain64(rl,buf,ptr-buf,1);

	buf = d_alloc(sizeof(INTEGER64)*2 + 1);
	ptr = get_compressed_code64(buf,len);
	set_recordlist_chain64(rl,buf,ptr-buf,1);

	for ( c = id->clk ; c ; c = c->next )
		hl_s2b_click(b,c,rl);
}


MATRIX_ALLOC_BLOCK_PARAM * hl_struct2block(MX_STRUCT_BLOCK * blk)
{
RECORD_LIST64 * rl;
MATRIX_ALLOC_BLOCK_PARAM * p;
int size;
HL_ID_LIST * id;
HL_STRUCT_BLOCK * i_blk;
	i_blk = (HL_STRUCT_BLOCK*)blk;
	rl = new_recordlist64(0,0);
	
	for ( id = i_blk->id_list ; id ; id = id->next )
		hl_s2b_id_list(i_blk,id,rl);
	
	size = setup_recordlist64(rl);
	
	p = d_alloc(sizeof(*p));
	memset(p,0,sizeof(*p));
	p->size = size;
	p->block = rl->data;
	rl->data = 0;
	free_recordlist64(rl);
	return p;
}




XL_SEXP *
xl_sbHeuristicLayering(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_TOKEN * t;
MX_SB_NEW n;
MX_STRUCT_BLOCK * b;
XL_SEXP * ch;
char * e_param;
	ch = eval(env,n_get_symbol("___channel"));
	switch ( get_type(ch) )  {
	case XLT_INTEGER:
		n.channel = ch->integer.data;
		break;
	case XLT_ERROR:
		return ch;
	default:
		e_param = "___channel";
		goto type_missmatch;
	}
	t = get_env_work(env);
	n.n = t->process_node;
	n.m = n.n->matrix;
	b = hl_new_sb(&n,0);
	return get_ptr(b,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetHTMLQuery"),
		List(n_get_string(
			"type missmatch"),
			n_get_string(e_param),
			-1));
}

void
init_sbHeuristicLayering(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"sbHeuristocLayering"),
		get_func_prim(xl_sbHeuristicLayering,FO_APPLICATIVE,0,1,1));
}




