/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
xl_mxSetSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxSetSB(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxSetSB"),
		get_func_prim(xl_mxSetSB,FO_NORMAL,0,2,2));
}


XL_SEXP *
xl_mxSetSB(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * ch;
int _ch;
XL_SEXP * ret;
MX_STRUCT_BLOCK * sb;
MATRIX_NODE * n;
MATRIX_TOKEN * t;
char * e_param;
MATRIX * m;
	t = get_env_work(env);
	n = t->process_node;
	m = n->matrix;
	_ch = -1;
	ch = get_sf_attribute(sf,l_string(std_cm,"channel"));
	e_param = "attr channel is required";
	if ( ch == 0 )
		goto inv_param;
	_ch = atoi(n_string(std_cm,ch));
	e_param = "channel data boundary error";
	if ( _ch < 0 || _ch >= n->matrix->p.channel_nos )
		goto inv_param;
	e_param = "channel data type is not match to block type";
	if ( m->channel_info[_ch].data_type != &mx_type_block )
		goto inv_param;
	env = new_env(env);
	set_env(env,l_string(std_cm,"___channel"),get_integer(_ch,0));
	ret = eval(env,get_el(s,1));
	switch ( get_type(ret) ) {
	case XLT_ERROR:
		return ret;
	case XLT_PTR:
		break;
	default:
		goto type_missmatch;
	}
	sb = ret->ptr.ptr;
	n->channel[_ch].sb = sb;
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxSetSB"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxSetSB"),
		List(n_get_string("invalid parameter in mxSetSB CH = "),
			get_integer(_ch,0),
			n_get_string(e_param),
			-1));
}





