/**********************************************************************
 
	Copyright (C) 2004 Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"init.h"
#include	"xl.h"
#include	"addrdb_jp.h"
#include	"xl_addrdb.h"
#include	"favt.h"

static int create_operation(const char* database_file, const char* csv_import_directory){
ADDRDB *db;
int ret;

	db = addrdb_open(database_file, addrdb_kokudo_get_locale(), ADOPT_INSERT_SKIP_ON_KEY_COLLISION);
	ret = addrdb_kokudo_import_csv_batch(db, csv_import_directory);
	addrdb_close(db);
	return ret;
}

static int convert_operation(
	const char *database_file, 
	const char *input_directory, 
	const char *output_directory,
	const char *input_file_encoding,
	int addr_str_colmun){
ADDRDB *db;
int ret;

	db = addrdb_open(database_file,  addrdb_kokudo_get_locale(), ADOPT_INSERT_SKIP_ON_KEY_COLLISION);
	ret = addrdb_convert_csv_batch(db, input_directory, output_directory, input_file_encoding, addr_str_colmun);
	addrdb_close(db);
	return ret;
}

static usage(){
	fprintf(stdout, "***********************************************************************\n");

	fprintf(stdout, "usage1: addrdb -create_kokudo database_file csv_import_directory\n\n");
	fprintf(stdout, "  This command create kokudo-koutu-syou gaiku-level-sansyou-jyouhou database \n");
	fprintf(stdout, "from csv files in 'csv_import_directory' to 'database_file'. \n");
	fprintf(stdout, "kokudo-koutu-syou gaiku-level-sansyou-jyouhou file's encoding must be Shift_JIS\n\n\n");
	
	fprintf(stdout, "usage2: addrdb -convert_csv database_file input_directory ");
	fprintf(stdout, "output_directory input_file_encoding colmun_index_of_address\n");
	fprintf(stdout, "This command batch convert csv files who has address-string.\n");
	fprintf(stdout, "'colmun_index_of_address' first colmun is 0");
	fprintf(stdout, "'output_directory' must exist.\n\n\n");
	
	fprintf(stdout, "usage3: addrdb foo.xl - -\n");
	fprintf(stdout, "  This command execute xlscript under the environment address database functions are defined.\n");
	fprintf(stdout, "***********************************************************************\n");
}

int
_main(int argc, char ** argv)
{
	init_xl(INI_DONTWAITCHI);
	init_favt();
	/*
	addrdb_test();
	*/
	if ( argc < 2 ) {
		fprintf(stderr,"too few argments\n");
		usage();
		exit(1);
	}
	
	if(strlen(argv[1])>3 && strcmp(&argv[1][strlen(argv[1])-3], ".xl")==0){
		init_function(gblisp_top_env0,gblisp_top_env1,argc,argv);
		
		init_AddrdbConvert(gblisp_top_env0);
		init_AddrdbImport(gblisp_top_env0);
		init_AddrdbOpen(gblisp_top_env0);
		init_AddrdbClose(gblisp_top_env0);
		
		xl_setup_file(argc,argv);
	}
	else{
		for(--argc,++argv; argc; --argc){
			if(strcmp(*argv, "-create_kokudo")==0){
				if(argc<=2){
					fprintf(stderr,"too few argments\n");
					usage();
					exit(1);
				}
				create_operation(argv[1], argv[2]);
				argv+=3;
				argc-=2;
			}
			else if(strcmp(*argv, "-convert_csv")==0){
				if(argc<=5){
					fprintf(stderr,"too few argments\n");
					usage();
					exit(1);
				}
				convert_operation(argv[1], argv[2], argv[3], argv[4], atoi(argv[5]));
				argv+=6;
				argc-=5;
			}
			*argv++;
		}
	}
	
	return 0;
}
