/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"avt.h"
#include	"gbview.h"
#include	<string.h>
#include	"memory_debug.h"
#include	"xl.h"
#include	"gif.h"
#include	"xlerror.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"win_flame.h"

typedef struct ri_gf {
	GBVIEW_FLAME *	gf;
	WF_ID		wfid;
} RI_GF;



int
gb_ri_func(int type,RI_QUEUE * rq,void * data)
{
RI_GF * src;
RI_GF * dest;
	src = (RI_GF*)data;
	switch ( type ) {
	case RICT_CALL:
		src = (RI_GF*)rq->data;
		if ( rq->ri->err == RIE_OK )
			win_flame_dirty(src->gf,src->wfid,0,
				WFF_PLOT_DIRTY,0);
		wf_lock(src->gf);
		src->gf->raw_image_request --;
//ss_printf("image- = %ls %i\n",rq->ri->path,src->gf->raw_image_request);
		wf_unlock(src->gf);
		return 0;
	case RICT_COPY:
		dest = d_alloc(sizeof(RI_GF));
		dest->gf = src->gf;
		dest->wfid = src->wfid;
		rq->data = dest;
		
		wf_lock(src->gf);
		src->gf->raw_image_request ++;
//ss_printf("image+ = %ls %i\n",rq->ri->path,src->gf->raw_image_request);
		wf_unlock(src->gf);
		return 0;
	case RICT_CMP:
		dest = (RI_GF*)rq->data;
		if ( dest->gf != src->gf )
			return -1;
		if ( dest->wfid != src->wfid )
			return -1;
		return 0;
	case RICT_DELETE:
		d_f_ree(rq->data);
		rq->data = 0;
		return 0;
	case RICT_TICK:
		return 0;
	default:
		er_panic("gb_ri_func");
		return 0;
	}
}

void *
get_ri(int * w,int * h,GBVIEW_FLAME * gf,WF_ID req,L_CHAR * path)
{
RI_GF rg;
int er;

	rg.gf = gf;
	rg.wfid = req;

	return  xl_get_ri(&er,w,h,gb_ri_func,&rg,path);
}






