/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_NODE_H___
#define VPF_NODE_H___

#include "vpf_types.h"
#include "vpf_container.h"
#include "vpf_table.h"
#include "vpf_variable_length_index.h"

typedef struct {
	LONG id;
	LONG pft_id[VPF_MAX_FEATURE_COL];
	LONG containing_face;
	LONG first_edge;
	VPF_COORDINATE coordinate;
}VPF_NODE_RECORD;

BOOL node_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
void node_record_delete(VPF_NODE_RECORD *edge);
VPF_NODE_RECORD *vpf_table_get_node(VPF_TABLE *table, LONG id);

#endif

