/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FILESPACE64_H___
#define ___FILESPACE64_H___

#include	"pdb64.h"

typedef struct freelist64 {
	PN64_FREELIST		f;
	U_INTEGER64		fofs;
	struct freelist64 *	next;
} FREELIST64;

#define SHORTEST_FREELIST_SIZE	\
	(sizeof(PN_HEADER)+ sizeof(PN64_FREELIST) - sizeof(PN64_HEADER))

#ifndef OPEN_FILESPACE
PDB64 * open_filespace64(char * filename,int oflags,int mode,int flags,...);
#else
PDB64* open_filespace64(char * filename,int oflags,int mode,
	int flags,int type,char * encoding);
#endif

void close_filespace64(PDB64 * p);

INTEGER64 alloc_filespace64(PDB64 *,PN64_HEADER * h);
void free_filespace64(PDB64 *,U_INTEGER64);
void * get_file_record64(U_INTEGER64 *,PDB64 *,short,INTEGER64);
void * read_filespace64(PDB64 *,unsigned int);
int write_filespace64(PDB64 *,void *);
void flush_filespace64(PDB64 * );

INTEGER64 fa_write64_header(PDB64 * ,void * d,U_INTEGER64 len);

int write_filespace64f(PDB64 * p,U_INTEGER64 fofs,void * h);

void *
xx_read_filespace64(PDB64 * p,U_INTEGER64 fofs,char * __file,int __line);
void *
xx_read_filespace64f(PDB64 * p,U_INTEGER64 fofs,char * __file,int __line);
void *
xx_read_filespace64_header
	(PDB64 * p,U_INTEGER64 fofs,char * __file,int __line);
void *
xx_read_filespace64f_header
	(PDB64 * p,U_INTEGER64 fofs,char * __file,int __line);

#define read_filespace64(p,fofs) \
	xx_read_filespace64(p,fofs,__FILE__,__LINE__)
#define read_filespace64f(p,fofs) \
	xx_read_filespace64f(p,fofs,__FILE__,__LINE__)
#define read_filespace64_header(p,fofs) \
	xx_read_filespace64_header(p,fofs,__FILE__,__LINE__)
#define read_filespace64f_header(p,fofs) \
	xx_read_filespace64f_header(p,fofs,__FILE__,__LINE__)
int check_freelist64(PDB64 * p);
void
test_file64(char * file,PDB64 * _p,INTEGER64 limit);

#endif

