/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"pri_level.h"
#include	"machine/chimera.h"

sem_t* new_semaphore();


#define SW_HASH_SIZE	99

typedef struct chimera_sw_hash {
	struct sw_hash *	next;
	unsigned int		key;
	int			cnt;
	sem_t  *		sem;
} CHIMERA_SW_HASH;

typedef struct chimera_key_list {
	struct chimera_key_list *	next;
	unsigned int			key;
} CHIMERA_KEY_LIST;

CHIMERA_SEM chimera_sw_lock,task_lock;
CHIMERA_KEY_LIST * chimera_key_list;

CHIMERA_SW_HASH * hash[SW_HASH_SIZE];
int chimera_init_flag;

void
chimera_sw_init()
{
	task_lock = chimera_new_lock();
	chimera_sw_lock = chimera_new_lock();
	chimera_init_flag = 1;
}

int ws_test;

void
chimera_sleep_task(unsigned int key,CHIMERA_SEM s,int pri_flag)
{
int pri;
unsigned int kk;
CHIMERA_SW_HASH * h;
	kk = key%SW_HASH_SIZE;
	if ( pri_flag && (semlock_mode == SLM_REALTIME)   )
		pri = push_pri(PRI_SLEEP_WAIT);
	chimera_lock_task(chimera_sw_lock,__FILE__,__LINE__);
	for ( h = hash[kk]; h ; h = h->next )
		if ( h->key == key ) {
			h->cnt ++;
			chimera_unlock_task(chimera_sw_lock,"sleep_task(1)",__FILE__,__LINE__);
			goto last;
		}

	h = malloc(sizeof(*h));
	h->key = key;
	h->cnt = 1;
	h->sem = new_semaphore();


	sem_trywait(h->sem);

	h->next = hash[kk];
	hash[kk] = h;
	chimera_unlock_task(chimera_sw_lock,"sleep_task(3)",__FILE__,__LINE__);
last:
	if ( s )
		chimera_unlock_task(s,"sleep_task(4)",__FILE__,__LINE__);
retry1:
	errno = 0;
	if ( sem_wait(h->sem) ) {
		if ( errno == EINTR )
			goto retry1;
	}
	chimera_lock_task(chimera_sw_lock,__FILE__,__LINE__);
	h->cnt --;
	if ( h->cnt == 0 ) {
/*
		for ( hp = &hash[kk] ; *hp ; hp = &(*hp)->next )
			if ( (*hp)->key == key ) {
				*hp = (*hp)->next;
				break;
			}
*/
		sem_close(h->sem);
		free(h);
	}
	chimera_unlock_task(chimera_sw_lock,"sleep_task(5)",__FILE__,__LINE__);
	return;
}


void
chimera_wakeup_task(unsigned int key,int pri_flag)
{
unsigned int kk;
int i;
CHIMERA_SW_HASH * h, ** hp;
int pri;

	kk = key%SW_HASH_SIZE;
	if ( pri_flag && (semlock_mode == SLM_REALTIME) )
		pri = push_pri(PRI_SLEEP_WAIT);
	chimera_lock_task(chimera_sw_lock,__FILE__,__LINE__);
	for ( hp = &hash[kk] ; *hp ; hp = &(*hp)->next )
		if ( (*hp)->key == key )
			goto next;
	chimera_unlock_task(chimera_sw_lock,"wakeup_task(1)",__FILE__,__LINE__);
	return;
next:
	h = *hp;
	*hp = h->next;
	for ( i = h->cnt ; i ; i -- )
		for ( ; sem_post(h->sem); );
	chimera_unlock_task(chimera_sw_lock,"wakeup_task(2)",__FILE__,__LINE__);
}

void
chimera_post_event()
{
	if ( chimera_key_list == 0 )
		return;
	PostEvent(keyUp,1);
}

void
normal_wakeup_task(unsigned int key,int lock_flag)
{
CHIMERA_KEY_LIST * k;
	if ( lock_flag )
		chimera_lock_task(task_lock,__FILE__,__LINE__);
	k = malloc(sizeof(*k));
	k->key = key;
	k->next = chimera_key_list;
	chimera_key_list = k;
	PostEvent(keyUp,1);
	if ( lock_flag )
		chimera_unlock_task(task_lock,"normal_wakeup_task",__FILE__,__LINE__);
}

typedef struct call_this_lst {
	struct call_this_lst *	next;
	int			tid;
	int			status;
} CALL_THIS_LST;

typedef struct call_this_t {
	CALL_THIS_LST *		head;
	CALL_THIS_LST *		tail;
	CALL_THIS_LST *		free_list;
} CALL_THIS_T;

CALL_THIS_LST *
search_call_this(CALL_THIS_T * tbl,int status,int tid)
{
CALL_THIS_LST * ret;
	for ( ret = tbl->head ; ret ; ret = ret->next )
		if ( ret->tid == tid && ret->status == status )
			return ret;
	return 0;
}

int
insert_call_this(CALL_THIS_T * tbl,int status,int tid)
{
CALL_THIS_LST * lst;
	
	if ( tbl->free_list ) {
		lst = tbl->free_list;
		tbl->free_list = lst->next;
	}
	else {
		lst = malloc(sizeof(*lst));
	}
	lst->next = 0;
	lst->status = status;
	lst->tid = tid;
	if ( tbl->head == 0 )
		tbl->head = tbl->tail = lst;
	else {
		tbl->tail->next = lst;
		tbl->tail = lst;
	}
	return 0;
}


int
delete_call_this(CALL_THIS_T * tbl,int status,int tid)
{
CALL_THIS_LST ** lp,*lst;
	for ( lp = &tbl->head ; *lp ; lp = &(*lp)->next ) {
		lst = *lp;
		if ( lst->tid == tid && lst->status == status ) {
			*lp = lst->next;
			lst->next = tbl->free_list;
			tbl->free_list = lst;
			if ( tbl->head == 0 )
				tbl->tail = 0;
			else if ( tbl->tail == lst ) {
				for ( lst = tbl->head ; lst->next ; lst = lst->next );
				tbl->tail = lst;
			}
			return 0;
		}
	}
	return -1;
}

int
normal_wakeup_routine(int status,int key)
{
CHIMERA_KEY_LIST * k,* k1;
int pri;
static CALL_THIS_T call_this;
int ret;
int tid;
CALL_THIS_LST * lst;

	if ( chimera_init_flag == 0 )
		return -1;
	ret = 0;
	tid = get_tid();
	switch ( status ) {
	case CHIMERA_N_WAKEUP_END:
		if ( call_this.head == 0 )
			return -1;
		if ( call_this.head->tid == tid )
			break;
		goto end;
	case CHIMERA_N_SLEEP_END:
		goto end;
	case CHIMERA_N_WAKEUP:
	case CHIMERA_N_SLEEP:
		if ( call_this.head )
			ret = -1;
		insert_call_this(&call_this,status,tid);
		if ( ret < 0 )
			return -1;
		break;
	default:
		if ( call_this.head )
			return -1;
		insert_call_this(&call_this,CHIMERA_N_LOCK,tid);
		break;
	}
	pri = get_pri(0);
	change_pri(0,PRI_MAX-1);

retry:
	k = chimera_key_list;
	if ( k == 0 )
		goto end;
//printf("NORMAL WAKEUP ROUTINE 3\n");
	chimera_lock_task(task_lock,__FILE__,__LINE__);
//printf("NORMAL WAKEUP ROUTINE 4\n");
	k = chimera_key_list;
	chimera_key_list = 0;
	chimera_unlock_task(task_lock,"normal_wakeup_routine",__FILE__,__LINE__);
	for ( ; k ; ) {
		k1 = k;
		k = k->next;
//printf("NORMAL WAKEUP ROUTINE %x\n",k1->key);
		if ( status == CHIMERA_N_SLEEP && k1->key == key )
			ret = 1;
		wakeup_task(k1->key);
		free(k1);
	}
//printf("NORMAL WAKEUP ROUTINE 5 %i\n",status);
	if ( chimera_key_list )
		goto retry;

	change_pri(0,pri);
end:
	switch ( status ) {
	case CHIMERA_N_WAKEUP:
		break;
	case CHIMERA_N_SLEEP:
		if ( ret == 1 )
			delete_call_this(&call_this,CHIMERA_N_SLEEP,tid);
		break;
	case CHIMERA_N_WAKEUP_END:
		delete_call_this(&call_this,CHIMERA_N_WAKEUP,tid);
		break;
	case CHIMERA_N_SLEEP_END:
		delete_call_this(&call_this,CHIMERA_N_SLEEP,tid);
		break;
	default:
		delete_call_this(&call_this,CHIMERA_N_LOCK,tid);
	}
//printf("NORMAL WAKEUP ROUTINE END\n");
	return ret;
}




