/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"xl.h"
#include	"memory_debug.h"
#include	"memory_routine.h"
#include	"utils.h"

XL_SEXP *
conv_if(XL_SEXP * s)
{
	return get_floating(s->integer.data,s->integer.unit);
}

XL_SEXP *
not_equal(XLISP_ENV * env,XL_SEXP * s1,XL_SEXP * s2)
{
	return get_integer(0,0);
}

XL_SEXP * 
conv_is(XL_SEXP * s)
{
L_CHAR * data;
char * d;
XL_SEXP * ret;
	d = d_alloc(20);
	if ( s->integer.unit ) {
		sprintf(d, I64_FORMAT, s->integer.data);
		data = d_alloc((l_strlen(s->integer.unit)
				+ strlen(d) + 1) * sizeof(L_CHAR));
		l_strcpy(data,l_string(std_cm,d));
		l_strcpy(&data[l_strlen(data)],s->integer.unit);
	}
	else {
		sprintf(d, I64_FORMAT, s->integer.data);
		data = nl_copy_str(std_cm,d);
	}
	d_f_ree(d);
	ret = get_string(data);
	d_f_ree(data);
	return ret;
}



XL_SEXP * 
conv_fs(XL_SEXP * s)
{
L_CHAR * data;
char * d;
XL_SEXP * ret;
	d = d_alloc(100);
	if ( s->floating.unit ) {
		sprintf(d,"%f",s->floating.data);
		data = d_alloc(
			(l_strlen(s->floating.unit) +
			strlen(d) + 1)*sizeof(L_CHAR));
		l_strcpy(data,l_string(std_cm,d));
		l_strcpy(&data[l_strlen(data)],s->integer.unit);
	}
	else {
		sprintf(d,"%f",s->floating.data);
		data = nl_copy_str(std_cm,d);
	}
	d_f_ree(d);
	ret = get_string(data);
	d_f_ree(data);
	return ret;
}


