/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"mxmap.h"


/*
dim_code = 0:-1
CHANNEL		0		double array

		[0]		offset to X
		[1]		offest to Y
		[2]
		....		number of src_dim
		[src_dim-1]

		[src_dim]	pitch of X
		[src_dim+1]	pitch of X
		...
		[2*src_dim-1]	pitch
CHANNEL		1		string array

		[0]		unit of source
		[1]		unit of destination


CHANNEL		8		block of SEND (zlib)	::SEND|FILE
				[corresponding with 10 - dest_dim+11]

CHANNEL		9		uint8 bit mask		::FILE

CHANNEL		10		double :: VISU|FILE
				[destination coordinate delta]

CHANNEL		11		double array :: VISU|FILE
				[resolution rate]

CHANNEL		12		double of array ::VISU|FILE
				[destination coordinate]
CHANNEL		13
		....
CHANNEL		dest_dim+11	double of array ::VISU|FILE



CHANNEL		dest_dim+12	double 			::FILE
				[sub. of this level ch10 - 0level ch10]

.....


CHANNEL		dest_dim+max_level+11	double
				[sub. of this level ch10 - 0level ch10]


CHANNEL_NOS = dest_dim+max_level+11;


*/


void
open_mxmap(MATRIX_TOKEN * t)
{
MATRIX * m;
MATRIX_PARAM p;
int er;
MATRIX_CHANNEL_INFO inf;

MXMAP_WORK * mw;
int i;
double dd_double;


	mw = (m=t->wait_matrix)->open_work;

	memset(&p,0,sizeof(p));
//	p.channel_nos = CH_MAX;
//	p.modify_time = ow->r->h.modify;
	p.flags = MPF_INDEX_HEM;
	p.dim = mw->src_dim;
	p.pri_area[MI_FETCH_1_TP] = PR_DOWN + 0x2000000;
	p.pri_area[MI_FETCH_1_MD] = PR_DOWN + 0x2000000;
	p.pri_area[MI_FETCH_1_BT] = PR_DOWN + 0x2000000;
	p.pri_area[MI_FETCH_2_TP] = PR_DOWN + 0x2000000;
	p.pri_area[MI_FETCH_2_MD] = PR_DOWN + 0x2000000;
	p.pri_area[MI_FETCH_2_BT] = PR_DOWN + 0x2000000;

	p.pri_area[MI_EDIT_1_TP] = PR_DOWN + 0x2000000;
	p.pri_area[MI_EDIT_1_MD] = PR_DOWN + 0x2000000;
	p.pri_area[MI_EDIT_1_BT] = PR_DOWN + 0x2000000;
	p.pri_area[MI_EDIT_2_TP] = PR_DOWN + 0x2000000;
	p.pri_area[MI_EDIT_2_MD] = PR_DOWN + 0x2000000;
	p.pri_area[MI_EDIT_2_BT] = PR_DOWN + 0x2000000;
	p.pri_area[MI_VISU_1_TP] = PR_DOWN + 0x2000000;
	p.pri_area[MI_VISU_1_MD] = PR_DOWN + 0x2000000;
	p.pri_area[MI_VISU_1_BT] = PR_DOWN + 0x2000000;
	p.pri_area[MI_SAVE_TP] = PR_DOWN + 0x4000000;
	p.pri_area[MI_SAVE_MD] = PR_DOWN + 0x4000000;
	p.pri_area[MI_SAVE_BT] = PR_DOWN + 0x4000000;

	p.write_file = matrix_standard_write_file;
	p.read_file = matrix_standard_read_file;
	p.close_file = close_matrix_file;
//	p.new_token = mxmap_new_token;
//	p.free_token = mxmap_free_token;
//	p.trigger = 0;


	er = set_matrix_param(m,&p);

	if ( er < 0 )
		goto error;
	for ( i = 0 ; i < mw->src_dim ; i ++ ) {
		er = set_matrix_dim_divide(m,i,1);	// divide 2^1
		if ( er < 0 )
			goto error;
		er = set_matrix_block_size(m,i,8);	// blocksize = 2^8
		if ( er < 0 )
			goto error;


		er = set_matrix_pixel_size(m,i,mw->pixel_size[i]);
		if ( er < 0 )
			goto error;

	}


	memset(&p,0,sizeof(p));
	p.channel_nos = m->total_levels + mw->dest_dim + CH_DATA;
	er = set_matrix_param(m,&p);
	if ( er < 0 )
		goto error;


	/* parameter NODE */
	
	dd_double = 0;
	inf.data_type = &mx_type_double_v;
	inf.flags = MF_FILE|MF_SEND;
	inf.default_data = &dd_double;
	er = set_matrix_channel_info(m,0,&inf);
	if ( er < 0 )
		goto error;
	inf.data_type = &mx_type_string_v;
	inf.flags = MF_FILE|MF_SEND;
	inf.default_data = 0;
	er = set_matrix_channel_info(m,1,&inf);
	if ( er < 0 )
		goto error;

	/* Data NODE */

	inf.data_type = &mx_type_block;
	inf.flags = MF_FILE|MF_SEND;
	inf.default_data = 0;
	er = set_matrix_channel_info(m,CH_SENDBLOCK,&inf);
	if ( er < 0 )
		goto error;


	inf.data_type = &mx_type_uint8_v;
	inf.flags = MF_FILE;
	inf.default_data = 0;
	er = set_matrix_channel_info(m,CH_BITMASK,&inf);
	if ( er < 0 )
		goto error;

	inf.data_type = &mx_type_double;
	inf.flags = MF_FILE;
	inf.default_data = &dd_double;
	er = set_matrix_channel_info(m,CH_DELTA,&inf);
	if ( er < 0 )
		goto error;

	inf.data_type = &mx_type_double_v;
	inf.flags = MF_FILE;
	inf.default_data = 0;
	er = set_matrix_channel_info(m,CH_RESO_RATE,&inf);
	if ( er < 0 )
		goto error;


	dd_double = 0;
	inf.data_type = &mx_type_double_v;
	inf.flags = MF_FILE;
	inf.default_data = &dd_double;
	for ( i = CH_DATA ; i < mw->dest_dim + CH_DATA ; i ++ ) {
		er = set_matrix_channel_info(m,i,&inf);
		if ( er < 0 )
			goto error;
	}

	inf.data_type = &mx_type_double;
	inf.flags = MF_FILE;
	for ( ; i < m->p.channel_nos ; i ++ ) {
		er = set_matrix_channel_info(m,i,&inf);
		if ( er < 0 )
			goto error;
	}

	set_matrix_cal(m,MI_FETCH_1_TP,
		sexp_commands(
			std_cm,
	"<If> (= create-node \"enable\") <Then>\n",
	"	<mxFinish\n",
	"		normal-jump-status=\"MS_OK\"\n",
	"		err-jump-status=\"MS_OK\"/>\n",
	"</Then><Else>\n",
	"	<mxFinish\n",
	"		normal-jump-status=\"MS_OK\"\n",
	"		err-jump-status=\"MS_PROCESS_ERR_1\"/>\n",
	"</Else></If>\n",
	"<mxLoad target=\"file\"/>\n",
			0));
	set_matrix_cal_equ(m,MI_FETCH_1_MD,MI_FETCH_1_TP);
	set_matrix_cal_equ(m,MI_FETCH_1_BT,MI_FETCH_1_TP);



	set_matrix_cal(m,MI_EDIT_1_BT,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_1\"/>\n",
	"<mxTrigger type=\"parent\"/>\n",
			0));


	set_matrix_cal(m,MI_EDIT_1_MD,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_1\"/>\n",
	"<Let>\n",
	"<Sub>\n",
	"	<cnt> ", sxc_int(mw->dest_dim), " </cnt>\n",
	"	<ch> ", sxc_int(CH_DATA), " </ch>\n",
	"</Sub>\n",
	"<mxSet> ", sxc_int(CH_BITMASK),
	" 		([mxThinnedOut type=\"representative\"\n",
	"			channel=\"",sxc_int(CH_BITMASK),"\"]\n",
	"		([mxCH type=\"children\"] \n",
				sxc_int(CH_BITMASK), "))\n",
	"</mxSet>",
	"<For dec=\"cnt\">",
	"	<mxSet> ^ch ([mxThinnedOut type=\"representative\"\n",
	"			channel=\"^ch\"] \n",
	"			([mxCH type=\"children\"] ch))\n",
	"	</mxSet>\n",
	"	<set> ^ch (+ ch 1) </set>\n",
	"</For>\n",
	"</Let>\n",
	"<mxTrigger type=\"parent\"/>\n",
			0));

	set_matrix_cal(m,MI_EDIT_1_TP,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_1\"/>\n",
	"<Let>\n",
	"<Sub>\n",
	"	<cnt> ", sxc_int(mw->dest_dim), " </cnt>\n",
	"	<ch> ", sxc_int(CH_DATA), " </ch>\n",
	"</Sub>"
	"<mxSet> ", sxc_int(CH_BITMASK),
	" 		([mxThinnedOut type=\"representative\"\n",
	"			channel=\"",sxc_int(CH_BITMASK),"\"]\n",
	"		([mxCH type=\"children\"] \n",
					sxc_int(CH_BITMASK), "))\n",
	"</mxSet>\n",
	"<For dec=\"cnt\">"
	"	<mxSet> ^ch ([mxThinnedOut type=\"representative\"\n",
	"			channel=\"^ch\"] "
	"			([mxCH type=\"children\"] ch))\n",
	"	</mxSet>\n",
	"	<set> ^ch (+ ch 1) </set>\n",
	"</For>\n",
	"</Let>\n",
			0));


	set_matrix_cal(m,MI_EDIT_2_BT,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_2\"/>\n",
	"<mxTrigger type=\"parent\"/>\n",
			0));

	set_matrix_cal(m,MI_EDIT_2_MD,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_2\"/>\n",

	"<Let>\n",
	"<Sub>\n",
	"	<cnt> (- max_levels this_level) </cnt>\n",
	"	<ch> (+ \n", sxc_int(mw->dest_dim+CH_DATA),
					" this_level) </ch>\n",
	"	<cnt2> \n", sxc_int(mw->dest_dim), " </cnt2>\n",
	"	<ch2>\n", sxc_int(CH_DATA), " </ch2>\n",
	"	<ret> () </ret>\n",
	"</Sub>"
	"<For dec=\"cnt\">"
	"	<mxSet> ^ch (mxMax ([mxCH type=\"children\"] ch))\n",
	"	</mxSet>\n",
	"	<set> ^ch (+ ch 1) </set>\n",
	"</For>\n",
	"<mxSet> \n", sxc_int(CH_DELTA),
	"	(mxCH (+ \n", sxc_int(mw->dest_dim+CH_DATA)," this_level))\n",
	"</mxSet>\n",
	"<set> ^ret (cons (mxCH \n", sxc_int(CH_DELTA), ") ()) </set>\n",
	"<For dec=\"cnt2\">\n",
	"	<Define> ^d (mxSquash (mxCH ch2)) </Define>\n",
	"	<mxSet> ^ch2 ^d </mxSet>\n",
	"	<set> ^ret (cons d ret) </set>\n",
	"	<set> ^ch2 (+ ch2 1) </set>\n",
	"</For>\n",
	"<mxSet> 8 (mxCompressZ (mxCompound (reverse ret))) </mxSet>\n",
	"</Let>\n",

	"<mxTrigger type=\"parent\"/>\n",
			0));

	set_matrix_cal(m,MI_EDIT_2_MD,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_2\"/>\n",
	"<mxTrigger type=\"parent\"/>\n",
			0));

	set_matrix_cal(m,MI_EDIT_2_MD,
		sexp_commands(
			std_cm,
	"<mxFinish\n",
	"	normal-jump-status=\"MS_OK\"\n",
	"	err-jump-status=\"MS_EDIT_ERR_2\"/>\n",

	"<Let>\n",
	"<Sub>\n",
	"	<cnt> (- max_levels this_level) </cnt>\n",
	"	<ch> (+ \n", sxc_int(mw->dest_dim+CH_DATA),
					" this_level) </ch>\n",
	"	<cnt2> \n", sxc_int(mw->dest_dim), " </cnt2>\n",
	"	<ch2>\n", sxc_int(CH_DATA), " </ch2>\n",
	"	<ret> () </ret>\n",
	"</Sub>"
	"<For dec=\"cnt\">"
	"	<mxSet> ^ch (mxMax ([mxCH type=\"children\"] ch))\n",
	"	</mxSet>\n",
	"	<set> ^ch (+ ch 1) </set>\n",
	"</For>\n",
	"<mxSet> \n", sxc_int(CH_DELTA),
	"	(mxCH (+ \n", sxc_int(mw->dest_dim+CH_DATA)," this_level))\n",
	"</mxSet>\n",
	"<set> ^ret (cons (mxCH \n", sxc_int(CH_DELTA), ") ()) </set>\n",
	"<For dec=\"cnt2\">\n",
	"	<Define> ^d (mxSquash (mxCH ch2)) </Define>\n",
	"	<mxSet> ^ch2 ^d </mxSet>\n",
	"	<set> ^ret (cons d ret) </set>\n",
	"	<set> ^ch2 (+ ch2 1) </set>\n",
	"</For>\n",
	"<mxSet> 8 (mxCompressZ (mxCompound (reverse ret))) </mxSet>\n",
	"</Let>\n",

			0));


	set_matrix_cal(m,MI_SAVE_TP,
		sexp_commands(
			std_cm,
			"<mxSave/>\n",
		0));
	set_matrix_cal_equ(m,MI_SAVE_MD,MI_SAVE_TP);
	set_matrix_cal_equ(m,MI_SAVE_BT,MI_SAVE_TP);
		
	save_matrix_header(m);
error:

	set_matrix_mode(m,MM_STANBY);
	;
	d_f_ree(t);


}
