/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "machine/include.h"
#include "vpf_std.h"
#include "vpf_edge.h"
#include "gm2svg.h"
#include "vpf_util.h"
#include "vpf_debug_util.h"
#include "vpf_table.h"
#include "change_endian.h"

static void to_path(char *str){
	if(str[strlen(str)-1] != '/' && str[strlen(str)-1] != '\\'){
		strcat(str,"/");
	}
}

int main(int argc, char *argv[]){
char src[MAX_PATH+1];
char dst[MAX_PATH+1];
char conf[MAX_PATH+1];

	if(argc <= 3){
		printf("usage: gm2svg output_path globalmapV1-library_path configure-file\n");
		return 0;
	}

	if(strlen(argv[1]) > MAX_PATH || 
		strlen(argv[2]) > MAX_PATH || 
		strlen(argv[3]) > MAX_PATH){
		printf("error: too long path\n");
		return -1;
	}
	
	strcpy(dst, argv[1]);
	strcpy(src, argv[2]);
	strcpy(conf, argv[3]);
	
	to_path(dst);
	to_path(src);
	
	check_endian();
	
	mkdir(dst,0777);
 	
	gm2svg(dst, src, conf);
	
	return 0;
}
