/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_SPLIT_VIEW_H___
#define ___V_SPLIT_VIEW_H___

#include "v/VObject.h"


class VSplitView : public VObject
{
  public:
	enum { object_type = VO_SPLV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return 2; }
	
	enum VSplitViewAttr {
		shrinkable0		= 0x01,
		shrinkable1		= 0x02,
		
		expand0_on_resize	= 0x10,
		expand1_on_resize	= 0x20,
		keep_ratio_on_resize	= 0x00,
		resize_mask		= 0x30
	};
	
	enum VSplitViewChildStatus {
		child_hidden		= 0x01,
		child_shrinked		= 0x02,
		child_shrinkable	= 0x04
	};
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	virtual void	value_changed();

	// show/hide pane = 0 or 1, expand/shrink_window = size diff of window or -1 to auto
	virtual void	show_pane(int pane, int expand_window = 0);
	virtual void	hide_pane(int pane, int shrink_window = 0);
	bool			is_pane_visible(int pane) const  { return !(child_status[pane?1:0]&child_hidden); }

	VObject*		get_child(int pane) const  { return pane ? child1 : child0; }
	char			get_child_status(int pane) const { return child_status[pane?1:0]; }
	
	const short*	get_def_size() const { return def_size; }
	VSize			get_last_size() const { return last_size; }	// for VLayout
	
  protected:
	virtual ~VSplitView();
	
	virtual void	destroy_do(VObject*);
	virtual VExError add_child_do(VObject*);
	virtual void	remove_child_do(VObject* child);
	
	VObject 	*child0, *child1;
	char		child_status[2];
	
	short		def_size[2];
	short		shrink_size[2];
	VSize		last_size;
};

class VHSplitView : public VSplitView
{
  public:
	enum { object_type = VO_HSPV };
	virtual unsigned	get_type() const { return object_type; }
	
	// def_size - default sizes for panes, or negative value to child min_size
	static VHSplitView*	create(const VObjectStatus *s, int flags,
			short def_size0, short def_size1, VExError *err=0) {
		short def_size[2] = {def_size0, def_size1};
		return create(s, flags, def_size, err);
	}
	static VHSplitView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VHSplitView*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}
	
  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);

  private:
	static VObject *internal_new(){
		return new VHSplitView();
	}
};

class VVSplitView : public VSplitView
{
  public:
	enum { object_type = VO_VSPV };
	virtual unsigned	get_type() const { return object_type; }
	
	// def_size - default sizes for panes, or negative value to child min_size
	static VVSplitView*	create(const VObjectStatus *s, int flags,
			short def_size0, short def_size1, VExError *err=0) {
		short def_size[2] = {def_size0, def_size1};
		return create(s, flags, def_size, err);
	}
	static VVSplitView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err=0) {
		return static_cast<VVSplitView*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}
	
  protected:
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);

  private:
	static VObject *internal_new(){
		return new VVSplitView();
	}
};

#endif
