/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"gbview.h"

int
dummy()
{
	return 0;
}

//int draw_pixel_data();
//int draw_map();
int draw_mark();
int draw_polygon2d();

int get_point_default();
int get_point_pixel_data();
int get_point_draw();

int get_point_mark();
int get_point_polygon2d();

int free_polygon2d();

int browse_coord();
int browse_draw_gb();
int browse_map();

int select_default();
int select_draw_gb();
int select_polygon2d();
int select_coordinate();
int select_mark();

int olist_polygon2d();
int olist_mark();

int check_default();
int check_coordinate();
int check_vector();

int exit_lock_coord();
int exit_lock_vector();
int exit_lock_luster();

int close_default();
int close_coord();
int close_pixel_map();

#include	"xl.h"
#include	"gbview.h"

char status_msg_table[][STS_MSG_TBL_LENGTH] = {
	"idle",
	"load",
	"error",
};


XL_SEXP * gv_new_coordinate();
XL_SEXP * gv_new_map();
XL_SEXP * gv_new_luster();
XL_SEXP * gv_new_vector();

GV_FUNC gv_new_table[RT_MAX] = {
	0,
	gv_new_coordinate,	/* coordinate */
	gv_new_map,		/* map */
	gv_new_vector,		/* draw_gb*/
	gv_new_luster		/* pixel data */
};


GBV_FUNC resource_table[RT_MAX][GBF_MAX] = {
	{0,0,0,0,0,0,0},
	{	0,
        	(GBV_FUNC)draw_coordinate,
		(GBV_FUNC)get_point_coordinate,
		0,
		(GBV_FUNC)browse_coord,
		(GBV_FUNC)select_coordinate,
		0,
		(GBV_FUNC)check_coordinate,
		(GBV_FUNC)exit_lock_coord,
		(GBV_FUNC)close_coord},
	{	0,
		(GBV_FUNC)draw_map,
		(GBV_FUNC)get_point_default,
		0,
		(GBV_FUNC)dummy,
		0,
		0,
		(GBV_FUNC)check_default,
		0,
		(GBV_FUNC)close_default},
	{	0,
		(GBV_FUNC)draw_draw_gb,
		(GBV_FUNC)get_point_draw,
		0,
		(GBV_FUNC)dummy,
		(GBV_FUNC)select_draw_gb,
		0,
		(GBV_FUNC)check_vector,
		(GBV_FUNC)exit_lock_vector,
		(GBV_FUNC)close_default},
	{	0,
		(GBV_FUNC)draw_pixel_data,
		(GBV_FUNC)get_point_pixel_data,
		0,
		(GBV_FUNC)dummy,
		(GBV_FUNC)select_default,
		0,
		(GBV_FUNC)check_default,
		(GBV_FUNC)exit_lock_luster,
		(GBV_FUNC)close_default}
};


GBV_FUNC object_table[OT_MAX][GBF_MAX] = {
	{0,0,0,0,0,0,0},
	{0,
		(GBV_FUNC)draw_polygon2d,
		(GBV_FUNC)get_point_polygon2d,
		(GBV_FUNC)free_polygon2d,
		0,
		(GBV_FUNC)select_polygon2d,
		(GBV_FUNC)olist_polygon2d,
		0},
	{0,
		(GBV_FUNC)draw_mark,
		(GBV_FUNC)get_point_mark,
		(GBV_FUNC)free_mark,
		0,
		(GBV_FUNC)select_mark,
		(GBV_FUNC)olist_mark,
		0}
};

