/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <windows.h>
#include <winbase.h>
#include <stdlib.h>

#include "stream.h"
#include "serial_port.h"

STREAM *s_open_file_descripter(HANDLE hfile, int open_mode, BOOL do_lock);


STREAM *
open_serial_port(SERIAL_PORT_INFO *info, int speed)
{
	HANDLE hComm;
	DCB dcb;
	COMMTIMEOUTS cto;

	hComm = CreateFile(info->name, GENERIC_READ |
			GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if( hComm == INVALID_HANDLE_VALUE ) {
		printf("Communication Error\n");
		getchar();
		exit(1);
	}
	
	GetCommState(hComm, &dcb);
	dcb.BaudRate = speed;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.fParity = FALSE;
	dcb.StopBits = ONESTOPBIT;
	SetCommState(hComm, &dcb);
	
	GetCommTimeouts(hComm, &cto);
	cto.ReadIntervalTimeout = 10;
	SetCommTimeouts(hComm, &cto);

	return s_open_file_descripter(hComm, O_RDWR, TRUE);
}
