/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VTabView.h"
#include "machine/v_object.h"



extern "C" void
v_tab_view_switch_page(GtkNotebook *notebook,
			GtkNotebookPage *page,
			guint page_num,
			VObject* vobj)
{
	vobj->value_changed();
}

extern "C" void
v_tab_view_make_pages(int n_pages, const L_CHAR **names, VInfo *info, VTabPage** pages)
{
	int i;
	GtkNotebook *nb = GTK_NOTEBOOK(info);
	
	for ( i = 0 ; i < n_pages ; i++ )
		gtk_notebook_append_page(nb, pages[i]->get_info_this(),
			gtk_label_new(ucd_n_string(names[i])));
}

VExError
VTabView::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	tab_set *set = (tab_set *)arg;
	n_pages = set->pages;
	
	info = v_serialized_exec_func(gtk_notebook_new);
	v_serialized_exec_sub(g_object_ref, info);
	VIA_MS_G_SIGNAL_CONNECT(info, "switch-page", v_tab_view_switch_page, this);
	
	VExError err = return_create_do(this,nmp,&sts,s,flags);
	if ( err.code != V_ER_NO_ERR )
		goto end;
	
	creating = 1;
	pages = new VTabPage*[n_pages];
	for ( int i = 0 ; i < n_pages ; i++ ) {
		VObjectStatus cs;
		cs.parent = this;
		pages[i] = VTabPage::create(&cs, VSF_PARENT, &err);
		if ( err.code != V_ER_NO_ERR )
			er_panic("VTabView::create_do");
	}
	creating = 0;
	
	v_serialized_exec_sub(v_tab_view_make_pages,
		n_pages, set->names, info, pages);
	
  end:
	return err;
}

void
VTabView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	delete[] pages;
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VTabView::~VTabView()
{
}

VExError
VTabView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	
	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(gtk_notebook_get_current_page,
			GTK_NOTEBOOK(info));
		flags &= ~VSF_VALUE;
	}
	
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VTabView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(gtk_notebook_set_current_page,
			GTK_NOTEBOOK(info), s->value);
		err.subcode1 &= ~VSF_VALUE;
	}
	
	V_OP_END
		
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

VExError
VTabView::add_child_do(VObject* child)
{
	// do nothing here
	// pages are added only in creation, and added to info in create_do
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VTabView::remove_child_do(VObject* child)
{
	v_serialized_exec_sub(gtk_container_remove, GTK_CONTAINER(info),
			child->get_info_this());
}

void
VTabView::child_status_changed(VObject *child, VInfo* cinfo)
{
	// do nothing
}

void
VTabView::value_changed()
{
	int v = v_serialized_exec_func(gtk_notebook_get_current_page,
			GTK_NOTEBOOK(info));
	if ( sts.value != v ) {
		sts.value = v;
		VObject::value_changed();
	}
}

void
VTabView::redraw(VRect *rect) const
{
	// do nothing
}

VTabPage*
VTabView::get_page(int n)
{
	VTabPage *ret;
	_V_OP_START(0)
	if ( n < 0 || n >= n_pages )
		ret = 0;
	else
		ret = pages[n];
	V_OP_END
	return ret;
}
