// ===========================================================================
//	CColorViewImp.cp
// ===========================================================================

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif

#include <CColorViewImp.h>
#include <LView.h>

#include <ControlDefinitions.h>

PP_Begin_Namespace_PowerPlant

const Pattern patb = {{0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff}};
const Pattern patw = {{0,0,0,0,0,0,0,0}};

/*
static pascal void
ControlUserPaneBackgroundProc (ControlHandle control, ControlBackgroundPtr)
{
	
	BackPat(&patw);
	RGBBackColor(&bgColor);
}
ControlUserPaneBackgroundUPP backgroundUPP =
		::NewControlUserPaneBackgroundUPP(ControlUserPaneBackgroundProc);
*/

pascal void
CColorViewImp::ControlUserPaneDrawProc(ControlRef control, ControlPartCode /*part*/)
{
	CColorViewImp *imp = (CColorViewImp *)GetControlReference(control);
	if ( ! imp->mIsColorSet )
		return;

	Rect rect;
	GetControlBounds(control, &rect);
	
	RGBForeColor(&imp->mColor);
	FillRect(&rect, &patb);
}
ControlUserPaneDrawUPP CColorViewImp::sDrawUPP =
		NewControlUserPaneDrawUPP(CColorViewImp::ControlUserPaneDrawProc);

pascal ControlPartCode
CColorViewImp::ControlUserPaneHitTestProc(ControlRef /*control*/, Point /*where*/)
{
	return kControlLabelPart;
}
ControlUserPaneHitTestUPP CColorViewImp::sHitTestUPP =
		NewControlUserPaneHitTestUPP(CColorViewImp::ControlUserPaneHitTestProc);

pascal void
CColorViewImp::ControlActionProc(ControlRef theControl, ControlPartCode partCode)
{

	CColorViewImp *imp = (CColorViewImp *)GetControlReference(theControl);
	imp->mControlPane->Draw(NULL);

	EventRecord er;
	LEventDispatcher::GetCurrentEvent(er);
	HandleControlClick(theControl, er.where, er.modifiers, NULL);

	imp->mControlPane->Draw(NULL);
}
ControlActionUPP CColorViewImp::sActionUPP =
		NewControlActionUPP(CColorViewImp::ControlActionProc);


// ---------------------------------------------------------------------------
//	 CColorViewImp				Stream/Default Constructor			  [public]
// ---------------------------------------------------------------------------
//	Do not access inStream. It may be nil. Read Stream data in Init()

CColorViewImp::CColorViewImp(
	LStream*		inStream)

	: LStdControlImp(inStream),
	  mIsColorSet(false), mColor(Color_White)
{
}


// ---------------------------------------------------------------------------
//	 ~CColorViewImp					Destructor					  [public]
// ---------------------------------------------------------------------------

CColorViewImp::~CColorViewImp()
{
}


// ---------------------------------------------------------------------------
//	 Init									Parameterized Initializer [public]
// ---------------------------------------------------------------------------

void
CColorViewImp::Init(
	LControlPane*	inControlPane,
	SInt16			inControlKind,
	ConstStringPtr	/*inTitle*/,
	ResIDT			inTextTraitsID,
	SInt32			/*inRefCon*/)
{
	mControlPane  = inControlPane;
	mControlKind  = inControlKind;
	mTextTraitsID = inTextTraitsID;
	
	Rect	frame;					// Get Frame in Local coordinates
	if (!CalcLocalFrameRect(frame)) {
		SDimension16	frameSize;
		mControlPane->GetFrameSize(frameSize);

		::MacSetRect(&frame, 0, 0, frameSize.width, frameSize.height);
	}

	mMacControlH = ::NewControl(UQDGlobals::GetCurrentWindowPort(),
				&frame, "\p", false,
				kControlSupportsEmbedding | kControlHasSpecialBackground,
				0, 0, kControlUserPaneProc, (long)this);

	ThrowIfNil_(mMacControlH);

/*
	ThrowIfOSErr_(::SetControlData(mMacControlH, kControlNoPart,
				kControlUserPaneBackgroundProcTag,
				sizeof(backgroundUPP), &backgroundUPP));
*/
	ThrowIfOSErr_(::SetControlData(mMacControlH, kControlNoPart,
				kControlUserPaneDrawProcTag,
				sizeof(sDrawUPP), &sDrawUPP));
	ThrowIfOSErr_(::SetControlData(mMacControlH, kControlNoPart,
				kControlUserPaneHitTestProcTag,
				sizeof(sHitTestUPP), &sHitTestUPP));
	::SetControlAction(mMacControlH, sActionUPP);
}


// ---------------------------------------------------------------------------
//	 GetForeAndBackColors											  [public]
// ---------------------------------------------------------------------------

bool
CColorViewImp::GetForeAndBackColors(
	RGBColor*	outForeColor,
	RGBColor*	outBackColor) const
{
	if (outForeColor != nil) {
		*outForeColor = Color_Black;
	}

	if (outBackColor != nil) {
		if ( mIsColorSet ) {
			BackPat(&patw);
			*outBackColor = mColor;
		}
		else
			return false;
	}

	return true;
}


PP_End_Namespace_PowerPlant
