/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"xl.h"
#include	"text_render.h"
#include	"tr_lang.h"
#include	"memory_debug.h"
#include	"ex_utils.h"
#include	"xlerror.h"



XL_SEXP *
ex_en_delim(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * delim;
XL_SEXP * ptr;
EN_WORK * enw;
L_CHAR * opt;
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	delim = get_sf_attribute(sf,l_string(std_cm,"data"));
	if ( delim == 0 )
		goto parameter;
	ptr = eval(env,n_get_symbol("___work"));
	if ( ptr == 0 )
		goto internal_error;
	enw = ptr->ptr.ptr;
	enw->delim = ex_option_copy(enw->delim,delim,opt);
	return 0;
parameter:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"delimiter"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"delimiter"),
		n_get_string("perhaps you exec outside of en env."));
}


XL_SEXP *
ex_en_space(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * delim;
XL_SEXP * ptr;
EN_WORK * enw;
L_CHAR * opt;
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	delim = get_sf_attribute(sf,l_string(std_cm,"data"));
	if ( delim == 0 )
		goto parameter;
	ptr = eval(env,n_get_symbol("___work"));
	if ( ptr == 0 )
		goto internal_error;
	enw = ptr->ptr.ptr;
	enw->space = ex_option_copy(enw->space,delim,opt);
	return 0;
parameter:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"space"),
		0);
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"space"),
		n_get_string("perhaps you exec outside of en env."));
}


void
init_ex_en(XLISP_ENV * env)
{
XLISP_ENV * e;
	e = new_env(env);
	e->e.work = &en_render;
	set_env(e,l_string(std_cm,"delimiter"),
		get_func_prim(ex_en_delim,FO_APPLICATIVE,0,1,1));
	set_env(e,l_string(std_cm,"space"),
		get_func_prim(ex_en_space,FO_APPLICATIVE,0,1,1));
	set_env(env,l_string(std_cm,"en"),
		get_func_prim(ex_body,FO_NORMAL,e,1,-1));
}



