/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"long_char.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_MakeElement();

void
init_MakeElement(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MakeElement"),
		get_func_prim(xl_MakeElement,FO_NORMAL,0,2,-1));
}

XL_SEXP *
xl_InsertAfter(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s)
{
XL_SEXP * ret1,* ret;
XL_SEXP * r, * r_sym;
XL_SEXP * sym;
XL_SEXP * ins;
int fg;
	if ( list_length(s) != 3 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_INV_PARAM_LENGTH,
			l_string(std_cm,"MakeElement/InsertAfter"),
			n_get_string("invalid parameter length"));

	sym = eval(env,get_el(s,1));
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		goto type_missmatch;
	}
	ins = eval(env,get_el(s,2));
	if ( get_type(ins) == XLT_ERROR )
		return ins;

	ret1 = 0;
	fg = 0;
	for ( ; get_type(el) ; el = cdr(el) ) {
		r = car(el);
		switch ( get_type(r) ) {
		case XLT_ERROR:
			return r;
		case XLT_PAIR:
			break;
		default:
			ret1 = cons(r,ret1);
			continue;
		}
		ret1 = cons(r,ret1);
		r_sym = car(r);
		switch ( get_type(r_sym) ) {
		case XLT_ERROR:
			return r_sym;
		case XLT_SYMBOL:
			break;
		default:
			continue;
		}
		if ( l_strcmp(sym->symbol.data,r_sym->symbol.data)
				== 0 ) {
			fg = 1;
		}
		else if ( fg ) {
			ret1 = cons(ins,ret1);
			el = cdr(el);
			goto next;
		}
	}
	ret1 = cons(ins,ret1);
next:
	for ( ; get_type(el) ; el = cdr(el) ) {
		r = car(el);
		if ( get_type(r) == 0 )
			return r;
		ret1 = cons(r,ret1);
	}
	ret = 0;
	for ( ; get_type(ret1) ; ret1 = cdr(ret1) )
		ret = cons(car(ret1),ret);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MakeElement/InsertAfter"),
		n_get_string("type missmatch"));
}

XL_SEXP *
xl_InsertBefore(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s)
{
XL_SEXP * ret1,* ret;
XL_SEXP * r, * r_sym;
XL_SEXP * sym;
XL_SEXP * ins;
	if ( list_length(s) != 3 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_INV_PARAM_LENGTH,
			l_string(std_cm,"MakeElement/InsertBefore"),
			n_get_string("invalid parameter length"));

	sym = eval(env,get_el(s,1));
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		goto type_missmatch;
	}
	ins = eval(env,get_el(s,2));
	if ( get_type(ins) == XLT_ERROR )
		return ins;

	ret1 = 0;
	for ( ; get_type(el) ; el = cdr(el) ) {
		r = car(el);
		switch ( get_type(r) ) {
		case XLT_ERROR:
			return r;
		case XLT_PAIR:
			break;
		default:
			goto loop_next;
		}
		r_sym = car(r);
		switch ( get_type(r_sym) ) {
		case XLT_ERROR:
			return r_sym;
		case XLT_SYMBOL:
			break;
		default:
			goto loop_next;
		}
		if ( l_strcmp(sym->symbol.data,r_sym->symbol.data)
				== 0 ) {
			ret1 = cons(ins,ret1);
			ret1 = cons(r,ret1);
			el = cdr(el);
			goto next;
		}
	loop_next:
		ret1 = cons(r,ret1);
	}
	ret1 = cons(ins,ret1);
next:
	for ( ; get_type(el) ; el = cdr(el) ) {
		r = car(el);
		if ( get_type(r) == 0 )
			return r;
		ret1 = cons(r,ret1);
	}
	ret = 0;
	for ( ; get_type(ret1) ; ret1 = cdr(ret1) )
		ret = cons(car(ret1),ret);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MakeElement/InsertBefore"),
		n_get_string("type missmatch"));
}


XL_SEXP *
xl_Delete(XLISP_ENV * env,XL_SEXP * el,XL_SEXP * s)
{
XL_SEXP * ret1,* ret;
XL_SEXP * r, * r_sym;
XL_SEXP * sym;
	if ( list_length(s) != 2 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_INV_PARAM_LENGTH,
			l_string(std_cm,"MakeElement/InsertBefore"),
			n_get_string("invalid parameter length"));

	sym = eval(env,get_el(s,1));
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		goto type_missmatch;
	}
	ret1 = 0;
	for ( ; get_type(el) ; el = cdr(el) ) {
		r = car(el);
		switch ( get_type(r) ) {
		case XLT_ERROR:
			return r;
		case XLT_PAIR:
			break;
		default:
			goto next;
		}
		r_sym = car(r);
		switch ( get_type(r_sym) ) {
		case XLT_ERROR:
			return r_sym;
		case XLT_SYMBOL:
			if ( l_strcmp(r_sym->symbol.data,sym->symbol.data)
					== 0 )
				continue;
			break;
		default:
			goto next;
		}
	next:
		ret1 = cons(r,ret1);
	}
	ret = 0;
	for ( ; get_type(ret1) ; ret1 = cdr(ret1) ) 
		ret = cons(car(ret1),ret);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MakeElement/InsertBefore"),
		n_get_string("type missmatch"));
}



XL_SEXP *
xl_MakeElement(
	XLISP_ENV * env,
	XL_SEXP * s)
{
XL_SEXP * el;
XL_SEXP * cmd,* sym;
XL_SEXP * r;


	el = eval(env,get_el(s,1));
	switch ( get_type(el) ) {
	case XLT_ERROR:
		return el;
	case XLT_PAIR:
		break;
	case XLT_NULL:
		break;
	default:
		goto type_missmatch;
	}
	for ( cmd = cdr(cdr(s)) ; get_type(cmd) ; cmd = cdr(cmd) ) {
		r = car(cmd);
		switch ( get_type(r) ) {
		case XLT_ERROR:
			return r;
		case XLT_PAIR:
			break;
		default:
			goto param_error1;
		}
		sym = car(r);
		switch ( get_type(sym) ) {
		case XLT_ERROR:
			return sym;
		case XLT_SYMBOL:
			break;
		default:
			goto param_error2;
		}
		if ( l_strcmp(sym->symbol.data,
				l_string(std_cm,"InsertAfter")) == 0 ) {
			el = xl_InsertAfter(env,el,r);
		}
		else if ( l_strcmp(sym->symbol.data,
				l_string(std_cm,"InsertBefore")) == 0 ) {
			el = xl_InsertBefore(env,el,r);
		}
		else if ( l_strcmp(sym->symbol.data,
				l_string(std_cm,"Delete")) == 0 ) {
			el = xl_Delete(env,el,r);
		}
		else {
			goto param_error3;
		}
		if ( get_type(el) == XLT_ERROR )
			return el;
	}
	return el;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MakeElement"),
		n_get_string("type missmatch"));
param_error1:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"MakeElement"),
		n_get_string("(Insert/Delete element is required)"));
param_error2:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"MakeElement"),
		n_get_string("(Insert/Delete element is required(symbol))"));
param_error3:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"MakeElement"),
		n_get_string("(Invalid tag"));
}

