/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdio.h>
#include	"long_char.h"
#include	"lcconv.h"

extern CODE_TABLE_HEADER * ct_root;

int
check_already(CODE_TABLE_HEADER * ct,CODE_ENTRY * ep)
{
CODE_TABLE_HEADER * cc;
CODE_ENTRY * e;
	for ( e = ep ; ; ) {
		for ( cc = ct_root ; cc != ct ; cc = cc->next ) {
			if ( (cc->lcz & cc->mask)
					== (e->code & cc->mask) )
				return 0;
		}
		e = e->co;
		if ( e == ep )
			break;
	}
	return -1;
}

void
print_code_table_t()
{
CODE_TABLE_HEADER * ct;
int i;
CODE_ENTRY * e, * ep;
	for ( ct = ct_root ; ct ; ct = ct->next ) {
		for ( i = 0 ; i < ct->len ; i ++ ) {
			ep = &ct->tbl[i];
			if ( check_already(ct,ep) == 0 )
				continue;

			for ( e = ep ; ; ) {
				printf("0x%x\t",(int)e->code);
				e = e->co;
				if ( e == ep )
					break;
			}
			printf("#\n");
		}
	}
}
